import { create } from "zustand";

interface SearchState {
  service: string;
  location: string;
  time: string;
  setService: (service: string) => void;
  setLocation: (location: string) => void;
  setTime: (time: string) => void;
}

interface CarouselState {
  recommendedIndex: number;
  newIndex: number;
  trendingIndex: number;
  reviewsIndex: number;
  setRecommendedIndex: (index: number) => void;
  setNewIndex: (index: number) => void;
  setTrendingIndex: (index: number) => void;
  setReviewsIndex: (index: number) => void;
}

export const useSearchStore = create<SearchState>((set) => ({
  service: "All treatments and venues",
  location: "Current location",
  time: "Any time",
  setService: (service: string) => set({ service }),
  setLocation: (location: string) => set({ location }),
  setTime: (time: string) => set({ time }),
}));

export const useCarouselStore = create<CarouselState>((set) => ({
  recommendedIndex: 0,
  newIndex: 0,
  trendingIndex: 0,
  reviewsIndex: 0,
  setRecommendedIndex: (index: number) => set({ recommendedIndex: index }),
  setNewIndex: (index: number) => set({ newIndex: index }),
  setTrendingIndex: (index: number) => set({ trendingIndex: index }),
  setReviewsIndex: (index: number) => set({ reviewsIndex: index }),
}));




