import { z } from "zod";

export const CouponTimeSlotSchema = z.object({
  day: z.string(),
  timeFrom: z.string(),
  timeTo: z.string(),
});

export const PromoCodeSchema = z.object({
  id: z.number(),
  promoCode: z.string(),
  type: z.string(),
  status: z.string(),
  value: z.number(),
  limit: z.number().nullable().optional(),
  applied: z.number().nullable().optional(),
  couponTimeSlots: z.array(CouponTimeSlotSchema).optional(),
});

export const ApplyCouponRequestSchema = z.object({
  promoCode: z.string(),
  salonId: z.string(),
  bookingDate: z.string(),
  bookingStartTime: z.string(),
  bookingEndTime: z.string(),
});

export const ApplyCouponResponseSchema = z.object({
  promoCode: PromoCodeSchema,
});

export type CouponTimeSlot = z.infer<typeof CouponTimeSlotSchema>;
export type PromoCode = z.infer<typeof PromoCodeSchema>;
export type ApplyCouponRequest = z.infer<typeof ApplyCouponRequestSchema>;
export type ApplyCouponResponse = z.infer<typeof ApplyCouponResponseSchema>;





