/**
 * React Query hook for fetching venue services
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { getVenueServicesClient } from "../api/getVenueServices";
import { Service } from "@/lib/schemas/service";

export interface UseVenueServicesParams {
  venueId: string;
  categoryId?: string;
}

export function useVenueServices(
  params: UseVenueServicesParams,
  options?: Omit<
    UseQueryOptions<Service[], Error, Service[], string[]>,
    "queryKey" | "queryFn"
  >
) {
  return useQuery({
    queryKey: ["venue-services", params.venueId, params.categoryId || "all"],
    queryFn: () => getVenueServicesClient(params),
    ...options,
  });
}




