/**
 * React Query hook for fetching venue reviews
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { getVenueReviewsClient } from "../api/getVenueReviews";
import { Review } from "@/lib/schemas/review";

export interface UseVenueReviewsParams {
  venueId: string;
  page?: number;
  limit?: number;
  sortBy?: "newest" | "oldest" | "highest" | "lowest";
}

export function useVenueReviews(
  params: UseVenueReviewsParams,
  options?: Omit<
    UseQueryOptions<
      { reviews: Review[]; total: number },
      Error,
      { reviews: Review[]; total: number },
      (string | number)[]
    >,
    "queryKey" | "queryFn"
  >
) {
  return useQuery({
    queryKey: [
      "venue-reviews",
      params.venueId,
      params.page || 1,
      params.limit || 10,
      params.sortBy || "newest",
    ],
    queryFn: () => getVenueReviewsClient(params),
    ...options,
  });
}




