import { Policies } from "@/lib/schemas/salonDetail";

interface SalonPoliciesProps {
  policies?: Policies;
}

export function SalonPolicies({ policies }: SalonPoliciesProps) {
  if (!policies) return null;

  const cancellationPolicies =
    policies.cancellationPolicies?.filter((p) => p.status) || [];
  const noShowPolicies =
    policies.noShowPolicies?.filter((p) => p.status) || [];
  const reschedulePolicies =
    policies.reschedulePolicies?.filter((p) => p.status) || [];
  const paymentPolicies =
    policies.paymentPolicies?.filter((p) => p.status) || [];

  const hasAnyPolicies =
    cancellationPolicies.length > 0 ||
    noShowPolicies.length > 0 ||
    reschedulePolicies.length > 0 ||
    paymentPolicies.length > 0;

  if (!hasAnyPolicies) return null;

  return (
    <div className="space-y-4">
      <h2 className="text-lg md:text-3xl font-bold">Policies</h2>
      <div className="space-y-6">
        {/* Cancellation Policies */}
        {cancellationPolicies.length > 0 && (
          <div className="space-y-2">
            <h3 className="font-semibold text-gray-900">Cancellation Policy</h3>
            <div className="space-y-3">
              {cancellationPolicies.map((policy, index) => (
                <div
                  key={policy.id || index}
                  className="p-4 bg-gray-50 rounded-lg border border-gray-200"
                >
                  <div className="space-y-1.5 text-sm text-gray-700">
                    {policy.hoursBeforeBooking && (
                      <p>
                        <span className="font-medium">Hours before booking:</span>{" "}
                        {policy.hoursBeforeBooking}
                      </p>
                    )}
                    {policy.refundPercentage !== null &&
                      policy.refundPercentage !== undefined && (
                        <p>
                          <span className="font-medium">Refund:</span>{" "}
                          {policy.refundPercentage}%
                        </p>
                      )}
                  </div>
                </div>
              ))}
            </div>
          </div>
        )}

        {/* No Show Policies */}
        {noShowPolicies.length > 0 && (
          <div className="space-y-2">
            <h3 className="font-semibold text-gray-900">No Show Policy</h3>
            <div className="space-y-3">
              {noShowPolicies.map((policy, index) => (
                <div
                  key={policy.id || index}
                  className="p-4 bg-gray-50 rounded-lg border border-gray-200"
                >
                  <div className="space-y-1.5 text-sm text-gray-700">
                    {policy.refundPercentage !== null &&
                      policy.refundPercentage !== undefined && (
                        <p>
                          <span className="font-medium">Refund:</span>{" "}
                          {policy.refundPercentage}%
                        </p>
                      )}
                  </div>
                </div>
              ))}
            </div>
          </div>
        )}

        {/* Reschedule Policies */}
        {reschedulePolicies.length > 0 && (
          <div className="space-y-2">
            <h3 className="font-semibold text-gray-900">Reschedule Policy</h3>
            <div className="space-y-3">
              {reschedulePolicies.map((policy, index) => (
                <div
                  key={policy.id || index}
                  className="p-4 bg-gray-50 rounded-lg border border-gray-200"
                >
                  <div className="space-y-1.5 text-sm text-gray-700">
                    {policy.hoursBeforeBooking !== null &&
                      policy.hoursBeforeBooking !== undefined && (
                        <p>
                          <span className="font-medium">Hours before booking:</span>{" "}
                          {policy.hoursBeforeBooking}
                        </p>
                      )}
                    {policy.count !== null && policy.count !== undefined && (
                      <p>
                        <span className="font-medium">Allowed reschedules:</span>{" "}
                        {policy.count}
                      </p>
                    )}
                  </div>
                </div>
              ))}
            </div>
          </div>
        )}

        {/* Payment Policies */}
        {paymentPolicies.length > 0 && (
          <div className="space-y-2">
            <h3 className="font-semibold text-gray-900">Payment Policy</h3>
            <div className="space-y-3">
              {paymentPolicies.map((policy, index) => (
                <div
                  key={policy.id || index}
                  className="p-4 bg-gray-50 rounded-lg border border-gray-200"
                >
                  <div className="space-y-1.5 text-sm text-gray-700">
                    {policy.percentage !== null &&
                      policy.percentage !== undefined && (
                        <p>
                          <span className="font-medium">Advance payment:</span>{" "}
                          {policy.percentage}%
                        </p>
                      )}
                  </div>
                </div>
              ))}
            </div>
          </div>
        )}
      </div>
    </div>
  );
}

