/**
 * Init Stripe Customer API - Client Side
 * Initializes Stripe customer on connect account
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  InitStripeCustomerRequestSchema,
  InitStripeCustomerResponseSchema,
  type InitStripeCustomerRequest,
  type InitStripeCustomerResponse,
} from "@/lib/schemas/stripe";

/**
 * Client-side: Initialize Stripe customer on connect account
 * Use in Client Components, React Query hooks
 */
export async function initStripeCustomerClient(
  request: InitStripeCustomerRequest
): Promise<InitStripeCustomerResponse> {
  // Validate request
  const validatedRequest = InitStripeCustomerRequestSchema.parse(request);

  const data = await clientFetcher<unknown>(
    "/customer/initStripeCustomerOnConnectAccount",
    {
      requireAuth: true,
      method: "POST",
      body: JSON.stringify(validatedRequest),
    }
  );

  return InitStripeCustomerResponseSchema.parse(data);
}

