/**
 * Client-side: Get favorites
 * Use in Client Components, React Query hooks
 */

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  GetFavoritesRequestSchema,
  GetFavoritesResponseSchema,
  type GetFavoritesRequest,
  type GetFavoritesResponse,
} from "@/lib/schemas/favorites";

export async function getFavoritesClient(
  request: GetFavoritesRequest
): Promise<GetFavoritesResponse> {
  // Validate request
  const validatedRequest = GetFavoritesRequestSchema.parse(request);

  // Build query parameters
  const queryParams = new URLSearchParams();
  queryParams.set("targetLat", validatedRequest.targetLat.toString());
  queryParams.set("targetLng", validatedRequest.targetLng.toString());
  queryParams.set("rangeInKm", validatedRequest.rangeInKm.toString());

  const endpoint = `/customer/favorites/salons?${queryParams.toString()}`;

  const data = await clientFetcher<unknown>(endpoint, {
    requireAuth: true, // Requires authentication
    method: "GET",
  });

  // Parse with better error handling
  try {
    return GetFavoritesResponseSchema.parse(data);
  } catch (error) {
    // Log the raw data for debugging
    console.error("Zod validation failed. Raw data:", JSON.stringify(data, null, 2));
    throw error;
  }
}
