/**
 * Get Appointment Detail API - Client Side
 * Fetches detailed information about a specific appointment
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  GetAppointmentDetailResponseSchema,
  type GetAppointmentDetailResponse,
} from "@/lib/schemas/appointmentDetail";

/**
 * Client-side: Get appointment detail
 * Use in Client Components, React Query hooks
 */
export async function getAppointmentDetailClient(
  appointmentId: number
): Promise<GetAppointmentDetailResponse> {
  const data = await clientFetcher<unknown>(
    `/customer/appointment-detail/${appointmentId}`,
    {
      requireAuth: true,
      method: "GET",
    }
  );

  // Log the raw data for debugging
  console.log(
    "Appointment detail API response:",
    JSON.stringify(data, null, 2)
  );

  // Parse with better error handling
  try {
    return GetAppointmentDetailResponseSchema.parse(data);
  } catch (error) {
    console.error(
      "Zod validation failed. Raw data:",
      JSON.stringify(data, null, 2)
    );
    throw error;
  }
}
