import { Venue } from "@/types/venue";

// Real data from screenshot
const mockRecommendedVenues: Venue[] = [
  {
    id: "1",
    slug: "the-nail-pavilion-jlt",
    name: "The Nail Pavilion JLT",
    image:
      "https://images.unsplash.com/photo-1516975080664-ed2fc6a32937?w=400&h=300&fit=crop",
    rating: 4.9,
    reviewCount: 969,
    category: "Nails",
    location: "Dubai",
    address: "Jumeirah Lakes Towers, Dubai",
  },
  {
    id: "2",
    slug: "keller-hair-studio",
    name: "Keller hair studio",
    image:
      "https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop",
    rating: 4.9,
    reviewCount: 659,
    category: "Hair Salon",
    location: "Singapore",
    address: "301 Upper Thomson Road, Bishan, Singapore",
  },
  {
    id: "3",
    slug: "b27-barbershop",
    name: "B27 Barbershop",
    image:
      "https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 509,
    category: "Barber",
    location: "Dubai",
    address: "Jumeirah Village Circle, Dubai",
  },
  {
    id: "4",
    slug: "akin-barber-25-hours-hotel",
    name: "Akin Barber and Shop at 25 Hours Hotel",
    image:
      "https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 1588,
    category: "Barber",
    location: "Dubai",
    address: "25Hours Hotel One Central, Trade Center St, D...",
  },
  {
    id: "5",
    slug: "additional-venue-1",
    name: "Additional Venue 1",
    image:
      "https://images.unsplash.com/photo-1540555700478-4be289fbecef?w=400&h=300&fit=crop",
    rating: 4.8,
    reviewCount: 423,
    category: "Beauty Salon",
    location: "London",
    address: "London, UK",
  },
  {
    id: "6",
    slug: "additional-venue-2",
    name: "Additional Venue 2",
    image:
      "https://images.unsplash.com/photo-1570172619644-dfd03e5f445e?w=400&h=300&fit=crop",
    rating: 4.7,
    reviewCount: 312,
    category: "Spa",
    location: "Manchester",
    address: "Manchester, UK",
  },
];

const mockNewVenues: Venue[] = [
  {
    id: "7",
    slug: "the-mani-pedi-spa-aipl",
    name: "The Mani Pedi Spa, AIPL Joy Street",
    image:
      "https://images.unsplash.com/photo-1516975080664-ed2fc6a32937?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 21,
    category: "Nails",
    location: "Gurugram",
    address: "Sector 66, Gurugram",
  },
  {
    id: "8",
    slug: "blue-tree-spa",
    name: "Blue Tree Spa",
    image:
      "https://images.unsplash.com/photo-1522337360788-8b13dee7a37e?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 6,
    category: "Massage",
    location: "Ghaziabad",
    address: "Indirapuram, Ghaziabad",
  },
  {
    id: "9",
    slug: "bebek-gents-salon",
    name: "Bebek Gents Salon L.L.C",
    image:
      "https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 4,
    category: "Barber",
    location: "Dubai",
    address: "Bebek Turkish Gents Salon, Prive Residence -",
  },
  {
    id: "10",
    slug: "bling-it",
    name: "Bling It",
    image:
      "https://images.unsplash.com/photo-1516975080664-ed2fc6a32937?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 422,
    category: "Nails",
    location: "Heraklion",
    address: "Ευαγ. Χατζάκη & Σιμωνόπετρας 1, Ηράκλειο Κρ...",
  },
  {
    id: "11",
    slug: "additional-new-venue-1",
    name: "Additional New Venue 1",
    image:
      "https://images.unsplash.com/photo-1604654894610-df63bc536371?w=400&h=300&fit=crop",
    rating: 4.9,
    reviewCount: 45,
    category: "Hair Salon",
    location: "Edinburgh",
    address: "Edinburgh, UK",
  },
  {
    id: "12",
    slug: "additional-new-venue-2",
    name: "Additional New Venue 2",
    image:
      "https://images.unsplash.com/photo-1605497788044-5a32c7078486?w=400&h=300&fit=crop",
    rating: 4.8,
    reviewCount: 38,
    category: "Spa",
    location: "Glasgow",
    address: "Glasgow, UK",
  },
];

const mockTrendingVenues: Venue[] = [
  {
    id: "11",
    slug: "luxury-hair-boutique",
    name: "Luxury Hair Boutique",
    image:
      "https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop",
    rating: 4.9,
    reviewCount: 423,
    category: "Hair Salon",
    location: "London",
    address: "London, UK",
  },
  {
    id: "12",
    slug: "royal-spa-experience",
    name: "Royal Spa Experience",
    image:
      "https://images.unsplash.com/photo-1522337360788-8b13dee7a37e?w=400&h=300&fit=crop",
    rating: 5.0,
    reviewCount: 389,
    category: "Spa & Wellness",
    location: "Manchester",
    address: "Manchester, UK",
  },
  {
    id: "13",
    slug: "classic-barbers",
    name: "Classic Barbers",
    image:
      "https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?w=400&h=300&fit=crop",
    rating: 4.9,
    reviewCount: 267,
    category: "Barbershop",
    location: "Birmingham",
    address: "Birmingham, UK",
  },
  {
    id: "14",
    slug: "beauty-haven",
    name: "Beauty Haven",
    image:
      "https://images.unsplash.com/photo-1540555700478-4be289fbecef?w=400&h=300&fit=crop",
    rating: 4.8,
    reviewCount: 334,
    category: "Beauty Salon",
    location: "Leeds",
    address: "Leeds, UK",
  },
];

export function useHomepageData() {
  // In production, this would fetch from an API
  return {
    recommendedVenues: mockRecommendedVenues,
    newVenues: mockNewVenues,
    trendingVenues: mockTrendingVenues,
  };
}
