"use client";

import { HorizontalCarousel } from "@/components/carousel/HorizontalCarousel";
import { VenueCard } from "./VenueCard";
import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";
import { Venue } from "@/types/venue";
import { routes } from "@/config/routes";

interface NewToFreshaSectionProps {
  venues: Venue[];
  lat: number;
  lng: number;
}

export function NewToFreshaSection({
  venues,
  lat,
  lng,
}: NewToFreshaSectionProps) {
  if (venues.length === 0) {
    return null;
  }

  return (
    <PageSection background="gradient-left" className="py-8 sm:py-12 md:py-16">
      <Container>
        <HorizontalCarousel
          title="Top rated"
          seeMoreLink={routes.saloonsWithParams("top-rated", lat, lng)}
        >
          {venues.map((venue) => (
            <VenueCard key={venue.id} venue={venue} />
          ))}
        </HorizontalCarousel>
      </Container>
    </PageSection>
  );
}
