/**
 * Get Home Venues API - Client Side Only
 * Fetches nearby salons/venues for the home page based on location
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  GetHomeVenuesRequestSchema,
  GetHomeVenuesResponseSchema,
  type GetHomeVenuesRequest,
  type GetHomeVenuesResponse,
} from "@/lib/schemas/home";

/**
 * Client-side: Get home venues
 * Use in Client Components, React Query hooks
 */
export async function getHomeVenuesClient(
  request: GetHomeVenuesRequest
): Promise<GetHomeVenuesResponse> {
  // Validate request
  const validatedRequest = GetHomeVenuesRequestSchema.parse(request);

  const data = await clientFetcher<unknown>("/customer/home", {
    requireAuth: false,
    method: "POST",
    body: JSON.stringify(validatedRequest),
  });

  return GetHomeVenuesResponseSchema.parse(data);
}






