import { Globe, Headphones } from "lucide-react";
import Link from "next/link";

export function AuthFooterLinks() {
  return (
    <div className="flex items-center gap-6 mt-auto pt-8">
      <Link
        href="/language"
        className="flex items-center gap-2 caption hover:text-primary-500 transition-colors"
      >
        <Globe className="w-4 h-4" />
        <span>English</span>
      </Link>
      <Link
        href="/help"
        className="flex items-center gap-2 caption hover:text-primary-500 transition-colors"
      >
        <Headphones className="w-4 h-4" />
        <span>Help and support</span>
      </Link>
    </div>
  );
}
