/**
 * Reset Password API
 * Updates password with secure hash generation and session token refresh
 */

import { API_BASE_URL } from "@/config/env";
import { getDeviceToken } from "@/lib/deviceToken";

export interface ResetPasswordRequest {
  password: string;
  userId: string;
  otpId: string;
  dvToken: string;
}

export interface ResetPasswordResponse {
  status: string;
  message: string;
  data: {
    accessToken: string;
    userId: string;
    firstName: string;
    lastName: string;
    email: string;
  };
  error: string;
}

/**
 * Reset password after OTP verification
 * Returns access token and user data
 */
export async function resetPassword(
  password: string,
  userId: string,
  otpId: string
): Promise<ResetPasswordResponse> {
  const dvToken = getDeviceToken();

  const response = await fetch(`${API_BASE_URL}/customer-auth/reset-password`, {
    method: "PATCH",
    headers: {
      "Content-Type": "application/json",
      Accept: "application/json",
    },
    body: JSON.stringify({
      password,
      userId,
      otpId,
      dvToken,
    }),
  });

  const data: ResetPasswordResponse = await response.json();
  return data;
}




