export const routes = {
  home: "/",
  auth: "/auth",
  login: "/login",
  signup: "/signup",
  signupCreate: "/signup/create",
  signupVerifyOtp: "/signup/verify-otp",
  forgotPassword: "/forgot-password",
  forgotPasswordVerifyOtp: "/forgot-password/verify-otp",
  resetPassword: "/reset-password",
  business: "/business",
  profile: "/profile",
  profileAppointments: "/profile/appointments",
  profileWallets: "/profile/wallets",
  profileFavorites: "/profile/favorites",
  profileForms: "/profile/forms",
  profileProductOrders: "/profile/product-orders",
  profileSettings: "/profile/settings",
  saloons: "/saloons",
  salonDetail: (id: string | number) => `/saloons/${id}`,
  salonServices: (id: string | number) => `/saloons/${id}/services`,
  salonProfessional: (id: string | number) => `/saloons/${id}/professional`,
  salonTime: (id: string | number) => `/saloons/${id}/time`,
  salonConfirm: (id: string | number) => `/saloons/${id}/confirm`,
  saloonsWithParams: (sort?: "near-you" | "top-rated" | "specialists", lat?: number, lng?: number) => {
    const params = new URLSearchParams();
    if (sort) params.set("sort", sort);
    if (lat !== undefined) params.set("lat", lat.toString());
    if (lng !== undefined) params.set("lng", lng.toString());
    const queryString = params.toString();
    return `/saloons${queryString ? `?${queryString}` : ""}`;
  },
  search: "/search",
} as const;
