import { ReactNode, CSSProperties } from 'react';

interface PageSectionProps {
  children: ReactNode;
  className?: string;
  background?: 'white' | 'gray' | 'gradient' | 'gradient-left';
  style?: CSSProperties;
}

export function PageSection({ 
  children, 
  className = '', 
  background = 'white',
  style
}: PageSectionProps) {
  const bgClasses = {
    white: 'bg-white',
    gray: 'bg-gray-50',
    gradient: 'bg-gradient-to-b from-pink-100 via-purple-50 to-blue-50/30',
    'gradient-left': 'bg-white',
  };

  const sectionStyle: CSSProperties | undefined = style || (background === 'gradient-left' ? {
    background: 'linear-gradient(to right, rgba(243, 232, 255, 0.2), rgba(255, 255, 255, 1) 30%)'
  } : undefined);

  return (
    <section 
      className={`${bgClasses[background]} ${className} relative`}
      style={sectionStyle}
    >
      {children}
    </section>
  );
}

