"use client";

import { ImageIcon } from "lucide-react";

interface PlaceholderImageProps {
  className?: string;
  style?: React.CSSProperties;
  text?: string;
}

export function PlaceholderImage({
  className = "",
  style,
  text = "No Picture Available",
}: PlaceholderImageProps) {
  return (
    <div
      className={`flex flex-col items-center justify-center bg-gray-100 ${className}`}
      style={style}
    >
      <ImageIcon className="w-12 h-12 mb-2" style={{ color: "var(--text-secondary)" }} />
      <p
        className="text-sm text-center px-4"
        style={{ color: "var(--text-secondary)" }}
      >
        {text}
      </p>
    </div>
  );
}






