# Running Production Build on Your PC as Server

This guide shows you how to run the production build on your PC and share it with colleagues via HTTPS (required for Google Pay/Apple Pay testing).

## 📋 Prerequisites

1. **Node.js 20+** installed
2. **ngrok** installed (for HTTPS tunnel) - Download from https://ngrok.com/download

## 🚀 Step-by-Step Instructions

### Step 1: Build Production Build

```bash
npm run build:production
```

This will:
- Build the app in production mode
- Use production Stripe keys
- Use production API URL

### Step 2: Start Production Server on Your PC

```bash
npm run start:production
```

Your app will be running on: `http://localhost:3000` (or `http://0.0.0.0:3000`)

**Note:** Keep this terminal window open!

### Step 3: Create HTTPS Tunnel with ngrok

Open a **new terminal window** and run:

```bash
ngrok http 3000
```

You'll see output like:
```
Forwarding  https://abc123.ngrok-free.app -> http://localhost:3000
```

**Copy the HTTPS URL** (e.g., `https://abc123.ngrok-free.app`)

### Step 4: Share with Colleagues

Share the ngrok HTTPS URL with your colleagues. They can access:
- `https://abc123.ngrok-free.app` (or whatever ngrok gives you)

## 🔧 Alternative: One-Command Setup

You can also build and start in one command:

```bash
npm run serve
```

Then in another terminal, run `ngrok http 3000`

## ⚙️ Environment Variables (Optional)

If you need to override API URL or Stripe keys, create a `.env.production` file:

```env
NODE_ENV=production
NEXT_PUBLIC_ENVIRONMENT=production
NEXT_PUBLIC_API_BASE_URL=https://stage.trimworldwide.com/
NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_LIVE=your_live_key
NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_TEST=your_test_key
```

## ✅ What This Enables

- ✅ Production build (optimized)
- ✅ HTTPS via ngrok (required for Google Pay/Apple Pay)
- ✅ Accessible from anywhere (colleagues can access)
- ✅ Production Stripe keys
- ✅ Google Pay and Apple Pay will work

## 🔒 Security Notes

1. **ngrok URLs are public** - Only share with trusted colleagues
2. **Free ngrok URLs change** each time you restart (paid plans offer fixed domains)
3. **Keep your PC running** while colleagues are testing
4. **Use test mode** in Stripe for testing (not live payments)

## 🛠️ Troubleshooting

### Port 3000 already in use?
Change the port in `package.json`:
```json
"start:production": "cross-env NODE_ENV=production NEXT_PUBLIC_ENVIRONMENT=production next start -H 0.0.0.0 -p 3001"
```
Then run: `ngrok http 3001`

### ngrok not found?
- Download from: https://ngrok.com/download
- Add to PATH or use full path: `C:\path\to\ngrok.exe http 3000`

### Google Pay/Apple Pay not showing?
- Make sure you're using the **HTTPS ngrok URL** (not localhost)
- Check browser console for errors
- Verify Stripe account has Google Pay/Apple Pay enabled
- Try in Chrome (for Google Pay) or Safari (for Apple Pay)

## 📝 Quick Reference

```bash
# Terminal 1: Build and start server
npm run serve

# Terminal 2: Create HTTPS tunnel
ngrok http 3000

# Share the HTTPS URL from ngrok with colleagues
```

