(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/sigitechnologies.cloud/src/lib/deviceToken.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Device Token Management
 * Generates and stores a unique device token for the current browser/device
 */ __turbopack_context__.s([
    "clearDeviceToken",
    ()=>clearDeviceToken,
    "getDeviceToken",
    ()=>getDeviceToken
]);
const DEVICE_TOKEN_KEY = "fresha_dv_token";
/**
 * Generate a unique device token
 */ function generateDeviceToken() {
    // Generate a unique token based on browser fingerprint
    const timestamp = Date.now();
    const random = Math.random().toString(36).substring(2, 15);
    const userAgent = ("TURBOPACK compile-time truthy", 1) ? window.navigator.userAgent : "TURBOPACK unreachable";
    const screen = ("TURBOPACK compile-time truthy", 1) ? `${window.screen.width}x${window.screen.height}` : "TURBOPACK unreachable";
    const fingerprint = `${timestamp}-${random}-${userAgent}-${screen}`;
    // Create a simple hash
    let hash = 0;
    for(let i = 0; i < fingerprint.length; i++){
        const char = fingerprint.charCodeAt(i);
        hash = (hash << 5) - hash + char;
        hash = hash & hash; // Convert to 32-bit integer
    }
    return `${hash}${timestamp}${random}`;
}
function getDeviceToken() {
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    let token = localStorage.getItem(DEVICE_TOKEN_KEY);
    if (!token) {
        token = generateDeviceToken();
        localStorage.setItem(DEVICE_TOKEN_KEY, token);
    }
    return token;
}
function clearDeviceToken() {
    if ("TURBOPACK compile-time truthy", 1) {
        localStorage.removeItem(DEVICE_TOKEN_KEY);
    }
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=sigitechnologies_cloud_src_lib_deviceToken_ts_d170bd5d._.js.map