(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/sigitechnologies.cloud/src/config/env.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Environment Configuration
 */ // Determine if we're in production mode
// Checks both NODE_ENV and custom environment variable
__turbopack_context__.s([
    "API_BASE_URL",
    ()=>API_BASE_URL,
    "API_ENDPOINTS",
    ()=>API_ENDPOINTS,
    "STRIPE_PUBLISHABLE_KEY",
    ()=>STRIPE_PUBLISHABLE_KEY,
    "googleApiKey",
    ()=>googleApiKey
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
const isProduction = ("TURBOPACK compile-time value", "development") === "production" || ("TURBOPACK compile-time value", "development") === "production";
const API_BASE_URL = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].env.NEXT_PUBLIC_API_BASE_URL || (("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "https://stage.trimworldwide.com/");
const API_ENDPOINTS = {
    emailChecker: "/customer-auth/emailChecker",
    signup: "/customer-auth/signup",
    verifyOtp: "/customer-auth/verify-otp",
    login: "/customer-auth/login",
    resendOtp: "/customer-auth/resend-otp",
    forgotPassword: "/customer-auth/forgot-password",
    verifyOtpForgotPassword: "/customer-auth/verify-otp-forget-password",
    resetPassword: "/customer-auth/reset-password"
};
const googleApiKey = ("TURBOPACK compile-time value", "AIzaSyD68_vw1gGE7LVVjJ5ZShy7qWwm9Rq0CBQ") || "";
// Stripe Configuration
// Test key (starts with pk_test_) - used in development
const STRIPE_PUBLIC_KEY_TEST = ("TURBOPACK compile-time value", "pk_test_51QwUMCCmsFtCbz25ucUenGGZyjVkF7Xl8LLZqUEy5Lq8Jy7m0ekdN9aR1okxf7AQAsIXqzS0KecEAFX7N10TmsPJ00YRPG3Wng") || "";
// Live key (starts with pk_live_) - used in production
const STRIPE_PUBLIC_KEY_LIVE = ("TURBOPACK compile-time value", "pk_live_51QwUM5EElwxEWjRbUD5LQ7CTZkwXaXHp6F5MXF5vRyGN3qW5GoJJClfvcWuf1r1LlbgzJLh1exeOyhIdmFKteKOa00uT0LtXbr") || "";
const STRIPE_PUBLISHABLE_KEY = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : STRIPE_PUBLIC_KEY_TEST;
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/lib/api/auth-client.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Client-side Authentication Helpers
 * Tokens are read from localStorage
 * Use this in Client Components
 */ __turbopack_context__.s([
    "getClientToken",
    ()=>getClientToken
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$auth$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/auth.ts [app-client] (ecmascript)");
;
function getClientToken() {
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    // Use existing auth helper for consistency
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$auth$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAccessToken"])();
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/lib/api/fetcher-client.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Client-side API Fetcher
 * Use in Client Components, React Query hooks
 */ __turbopack_context__.s([
    "ApiError",
    ()=>ApiError,
    "clientFetcher",
    ()=>clientFetcher
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/env.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$auth$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/api/auth-client.ts [app-client] (ecmascript)");
"use client";
;
;
class ApiError extends Error {
    status;
    message;
    statusCode;
    error;
    constructor(status, message, statusCode, error){
        super(message), this.status = status, this.message = message, this.statusCode = statusCode, this.error = error;
        this.name = "ApiError";
    }
}
/**
 * Normalize API response data to camelCase
 */ function normalizeToCamelCase(obj) {
    if (obj === null || obj === undefined) {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map(normalizeToCamelCase);
    }
    if (typeof obj !== "object") {
        return obj;
    }
    const normalized = {};
    for (const [key, value] of Object.entries(obj)){
        const camelKey = key.replace(/_([a-z])/g, (_, letter)=>letter.toUpperCase());
        normalized[camelKey] = normalizeToCamelCase(value);
    }
    return normalized;
}
async function clientFetcher(endpoint, options = {}) {
    const { requireAuth = true, headers: customHeaders = {}, ...fetchOptions } = options;
    // Ensure endpoint starts with / and API_BASE_URL doesn't end with /
    const cleanEndpoint = endpoint.startsWith("/") ? endpoint : `/${endpoint}`;
    const cleanBaseUrl = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"].endsWith("/") ? __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"].slice(0, -1) : __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"];
    const url = `${cleanBaseUrl}${cleanEndpoint}`;
    // Log the full URL for debugging (remove in production)
    if ("TURBOPACK compile-time truthy", 1) {
        console.log("[clientFetcher] Full URL:", url);
        console.log("[clientFetcher] Method:", fetchOptions.method || "GET");
    }
    // Build headers
    const headersObj = {
        "Content-Type": "application/json",
        Accept: "application/json"
    };
    // Add custom headers if provided as a plain object
    if (customHeaders && typeof customHeaders === "object" && !Array.isArray(customHeaders) && !(customHeaders instanceof Headers)) {
        Object.assign(headersObj, customHeaders);
    }
    // Add authentication token from localStorage
    if (requireAuth) {
        const token = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$auth$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getClientToken"])();
        if (token) {
            headersObj.accessToken = token;
        }
    }
    // Add device token
    try {
        const { getDeviceToken } = await __turbopack_context__.A("[project]/sigitechnologies.cloud/src/lib/deviceToken.ts [app-client] (ecmascript, async loader)");
        const deviceToken = getDeviceToken();
        if (deviceToken) {
            headersObj["X-Device-Token"] = deviceToken;
        }
    } catch (error) {
    // Device token is optional
    }
    // Convert to HeadersInit for fetch
    const headers = headersObj;
    try {
        const response = await fetch(url, {
            ...fetchOptions,
            headers
        });
        // Handle non-JSON responses
        const contentType = response.headers.get("content-type");
        if (!contentType?.includes("application/json")) {
            throw new ApiError("0", `Unexpected response type: ${contentType}`, response.status);
        }
        const data = await response.json();
        // Log response for debugging (remove in production)
        if ("TURBOPACK compile-time truthy", 1) {
            console.log("[clientFetcher] Response status:", response.status);
            console.log("[clientFetcher] Response data:", data);
        }
        // Check if status indicates an error
        if (data.status !== "1" && data.status !== "2") {
            // Log error details
            console.error("[clientFetcher] API Error:", {
                status: data.status,
                message: data.message,
                error: data.error,
                httpStatus: response.status
            });
            throw new ApiError(data.status, data.message || data.error || "An error occurred", response.status, data.error);
        }
        // Normalize and return data
        const normalizedData = normalizeToCamelCase(data.data);
        return normalizedData;
    } catch (error) {
        // Re-throw ApiError as-is
        if (error instanceof ApiError) {
            throw error;
        }
        // Handle network errors
        if (error instanceof TypeError && error.message === "Failed to fetch") {
            throw new ApiError("0", "Network error. Please check your connection.", 0);
        }
        // Handle other errors
        throw new ApiError("0", error instanceof Error ? error.message : "An unexpected error occurred", 500);
    }
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/search/api/getServiceTypes-client.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Get Service Types API - Client Side Only
 * Fetches all available service types
 */ __turbopack_context__.s([
    "getServiceTypesClient",
    ()=>getServiceTypesClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$fetcher$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/api/fetcher-client.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/zod/v4/classic/external.js [app-client] (ecmascript) <export * as z>");
"use client";
;
;
const ServiceTypeSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    id: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    typeName: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    image: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    serviceOrder: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    status: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].boolean(),
    createdAt: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
});
async function getServiceTypesClient() {
    const data = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$fetcher$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["clientFetcher"])("/customer/service-types", {
        requireAuth: false,
        method: "GET"
    });
    // clientFetcher already extracts data.data, so we get the array directly
    const parsed = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(ServiceTypeSchema).parse(data);
    return parsed;
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/lib/schemas/home.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Zod Schemas for Home page API
 */ __turbopack_context__.s([
    "AddressDBSchema",
    ()=>AddressDBSchema,
    "GetHomeVenuesRequestSchema",
    ()=>GetHomeVenuesRequestSchema,
    "GetHomeVenuesResponseSchema",
    ()=>GetHomeVenuesResponseSchema,
    "HomeSalonSchema",
    ()=>HomeSalonSchema,
    "HomeServiceSchema",
    ()=>HomeServiceSchema
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/zod/v4/classic/external.js [app-client] (ecmascript) <export * as z>");
;
const AddressDBSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    id: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    streetAddress: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    city: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    district: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    province: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    country: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    lat: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    lng: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    building: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    postalCode: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    zoneId: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number().nullable()
});
const HomeServiceSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    id: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    serviceName: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    price: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    discount: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number()
});
const HomeSalonSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    id: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    salonName: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    coverImage: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().nullable(),
    isExternalEmployee: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].boolean(),
    isOnline: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].boolean(),
    // API can return rating as string or number, coerce to number
    salonAverageRating: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].any().transform((val)=>{
        if (val === null || val === undefined || val === "" || val === "null") {
            return null;
        }
        if (typeof val === "number") {
            return val;
        }
        if (typeof val === "string") {
            const parsed = parseFloat(val);
            return isNaN(parsed) ? null : parsed;
        }
        return null;
    }).pipe(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number().nullable()),
    ratingCount: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    distance: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    addressDB: AddressDBSchema,
    services: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(HomeServiceSchema),
    user: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
        id: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number()
    }),
    like: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].boolean(),
    averageDiscount: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number()
});
const GetHomeVenuesRequestSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    targetLat: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    targetLng: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number(),
    rangeInKm: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number().min(0),
    serviceType: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().nullable().optional()
});
const GetHomeVenuesResponseSchema = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    slons: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(HomeSalonSchema),
    appointments: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].unknown()).optional(),
    currencyUnit: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    distanceUnit: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    highestPriceAcrossAllSalons: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    lowestPriceAcrossAllSalons: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$zod$2f$v4$2f$classic$2f$external$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
});
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/api/getHomeVenues-client.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Get Home Venues API - Client Side Only
 * Fetches nearby salons/venues for the home page based on location
 */ __turbopack_context__.s([
    "getHomeVenuesClient",
    ()=>getHomeVenuesClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$fetcher$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/api/fetcher-client.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$schemas$2f$home$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/schemas/home.ts [app-client] (ecmascript)");
"use client";
;
;
async function getHomeVenuesClient(request) {
    // Validate request
    const validatedRequest = __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$schemas$2f$home$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["GetHomeVenuesRequestSchema"].parse(request);
    const data = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$api$2f$fetcher$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["clientFetcher"])("/customer/home", {
        requireAuth: false,
        method: "POST",
        body: JSON.stringify(validatedRequest)
    });
    return __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$schemas$2f$home$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["GetHomeVenuesResponseSchema"].parse(data);
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/utils/transformSalonToVenue.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Transform HomeSalon from API to Venue format
 */ __turbopack_context__.s([
    "transformSalonToVenue",
    ()=>transformSalonToVenue
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/env.ts [app-client] (ecmascript)");
;
function transformSalonToVenue(salon) {
    const address = salon.addressDB;
    const fullAddress = [
        address.streetAddress,
        address.city,
        address.district,
        address.province,
        address.country
    ].filter(Boolean).join(", ");
    // Handle image URL - convert relative paths to absolute URLs
    // Use a placeholder URL that can be detected for showing placeholder component
    let imageUrl = "/placeholder-venue";
    if (salon.coverImage) {
        if (salon.coverImage.startsWith("http://") || salon.coverImage.startsWith("https://")) {
            imageUrl = salon.coverImage;
        } else if (salon.coverImage.startsWith("/")) {
            imageUrl = `${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"]}${salon.coverImage}`;
        } else {
            // Relative path like "Public/Gallery/..." - prepend base URL with leading slash
            imageUrl = `${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"]}/${salon.coverImage}`;
        }
    }
    return {
        id: salon.id.toString(),
        slug: salon.id.toString(),
        name: salon.salonName,
        image: imageUrl,
        rating: salon.salonAverageRating ?? 0,
        reviewCount: salon.ratingCount,
        category: salon.services[0]?.serviceName || "Service",
        location: address.city,
        address: fullAddress,
        badge: salon.isOnline ? "Online" : undefined
    };
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ServiceTypesDropdown",
    ()=>ServiceTypesDropdown
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/search.js [app-client] (ecmascript) <export default as Search>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/map-pin.js [app-client] (ecmascript) <export default as MapPin>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$api$2f$getServiceTypes$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/search/api/getServiceTypes-client.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$api$2f$getHomeVenues$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/home/api/getHomeVenues-client.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$utils$2f$transformSalonToVenue$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/home/utils/transformSalonToVenue.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/image.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/env.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/navigation.js [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
;
function ServiceTypesDropdown({ isOpen, onClose, onSelect, selectedService, location }) {
    _s();
    const router = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"])();
    const [serviceTypes, setServiceTypes] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [searchQuery, setSearchQuery] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])("");
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [venues, setVenues] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [isLoadingVenues, setIsLoadingVenues] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const dropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ServiceTypesDropdown.useEffect": ()=>{
            if (isOpen) {
                fetchServiceTypes();
            }
        }
    }["ServiceTypesDropdown.useEffect"], [
        isOpen
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ServiceTypesDropdown.useEffect": ()=>{
            const handleClickOutside = {
                "ServiceTypesDropdown.useEffect.handleClickOutside": (event)=>{
                    if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
                        onClose();
                    }
                }
            }["ServiceTypesDropdown.useEffect.handleClickOutside"];
            if (isOpen) {
                document.addEventListener("mousedown", handleClickOutside);
            }
            return ({
                "ServiceTypesDropdown.useEffect": ()=>{
                    document.removeEventListener("mousedown", handleClickOutside);
                }
            })["ServiceTypesDropdown.useEffect"];
        }
    }["ServiceTypesDropdown.useEffect"], [
        isOpen,
        onClose
    ]);
    const fetchServiceTypes = async ()=>{
        setIsLoading(true);
        try {
            const data = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$api$2f$getServiceTypes$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getServiceTypesClient"])();
            // Sort by serviceOrder
            const sorted = [
                ...data
            ].sort((a, b)=>a.serviceOrder - b.serviceOrder);
            setServiceTypes(sorted);
        } catch (error) {
            console.error("Failed to fetch service types:", error);
            setServiceTypes([]);
        } finally{
            setIsLoading(false);
        }
    };
    // Fetch venues when user types in search
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ServiceTypesDropdown.useEffect": ()=>{
            if (searchQuery.trim().length > 0 && location) {
                const fetchVenues = {
                    "ServiceTypesDropdown.useEffect.fetchVenues": async ()=>{
                        setIsLoadingVenues(true);
                        try {
                            const response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$api$2f$getHomeVenues$2d$client$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getHomeVenuesClient"])({
                                targetLat: location.lat,
                                targetLng: location.lng,
                                rangeInKm: 10,
                                serviceType: null
                            });
                            const transformedVenues = response.slons.map(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$utils$2f$transformSalonToVenue$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["transformSalonToVenue"]);
                            // Filter venues by search query
                            const filtered = transformedVenues.filter({
                                "ServiceTypesDropdown.useEffect.fetchVenues.filtered": (venue)=>venue.name.toLowerCase().includes(searchQuery.toLowerCase()) || venue.location.toLowerCase().includes(searchQuery.toLowerCase()) || venue.address.toLowerCase().includes(searchQuery.toLowerCase())
                            }["ServiceTypesDropdown.useEffect.fetchVenues.filtered"]);
                            setVenues(filtered);
                        } catch (error) {
                            console.error("Failed to fetch venues:", error);
                            setVenues([]);
                        } finally{
                            setIsLoadingVenues(false);
                        }
                    }
                }["ServiceTypesDropdown.useEffect.fetchVenues"];
                // Debounce the search
                const timeoutId = setTimeout({
                    "ServiceTypesDropdown.useEffect.timeoutId": ()=>{
                        fetchVenues();
                    }
                }["ServiceTypesDropdown.useEffect.timeoutId"], 300);
                return ({
                    "ServiceTypesDropdown.useEffect": ()=>clearTimeout(timeoutId)
                })["ServiceTypesDropdown.useEffect"];
            } else {
                setVenues([]);
            }
        }
    }["ServiceTypesDropdown.useEffect"], [
        searchQuery,
        location
    ]);
    const filteredServices = serviceTypes.filter((service)=>service.typeName.toLowerCase().includes(searchQuery.toLowerCase()));
    const handleVenueClick = (venue)=>{
        router.push(`/saloons/${venue.id}`);
        onClose();
    };
    const getImageUrl = (imagePath)=>{
        if (imagePath.startsWith("http://") || imagePath.startsWith("https://")) {
            return imagePath;
        }
        return imagePath.startsWith("/") ? `${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"]}${imagePath}` : `${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_BASE_URL"]}/${imagePath}`;
    };
    if (!isOpen) return null;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        ref: dropdownRef,
        className: "absolute top-full left-0 mt-2 bg-white rounded-xl shadow-lg border border-gray-200 z-50 max-h-96 overflow-hidden flex flex-col",
        style: {
            width: "312px"
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "p-4 border-b border-gray-200",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__["Search"], {
                            className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                            lineNumber: 144,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                            type: "text",
                            placeholder: "Search services...",
                            value: searchQuery,
                            onChange: (e)=>setSearchQuery(e.target.value),
                            className: "w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                            lineNumber: 145,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                    lineNumber: 143,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                lineNumber: 142,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "overflow-y-auto flex-1",
                children: isLoading ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "p-8 text-center text-gray-500",
                    children: "Loading..."
                }, void 0, false, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                    lineNumber: 158,
                    columnNumber: 11
                }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Fragment"], {
                    children: [
                        !searchQuery && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            onClick: ()=>{
                                onSelect(null);
                                onClose();
                            },
                            className: `w-full px-4 py-3 text-left hover:bg-gray-50 flex items-center gap-3 ${!selectedService ? "bg-purple-50" : ""}`,
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-10 h-10 rounded-lg bg-gray-100 flex items-center justify-center border border-gray-200",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "grid grid-cols-2 gap-0.5",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "w-1.5 h-1.5 bg-gray-400 rounded-sm"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 174,
                                                columnNumber: 21
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "w-1.5 h-1.5 bg-gray-400 rounded-sm"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 175,
                                                columnNumber: 21
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "w-1.5 h-1.5 bg-gray-400 rounded-sm"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 176,
                                                columnNumber: 21
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "w-1.5 h-1.5 bg-gray-400 rounded-sm"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 177,
                                                columnNumber: 21
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                        lineNumber: 173,
                                        columnNumber: 19
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 172,
                                    columnNumber: 17
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: "body-text",
                                    children: "All treatments"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 180,
                                    columnNumber: 17
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                            lineNumber: 163,
                            columnNumber: 15
                        }, this),
                        !searchQuery && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "px-4 py-2",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                className: "heading-6 text-gray-900",
                                children: "Top categories"
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                lineNumber: 187,
                                columnNumber: 17
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                            lineNumber: 186,
                            columnNumber: 15
                        }, this),
                        filteredServices.length > 0 ? filteredServices.map((service)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>{
                                    onSelect(service);
                                    onClose();
                                },
                                className: `w-full px-4 py-3 text-left hover:bg-gray-50 flex items-center gap-3 ${selectedService?.id === service.id ? "bg-purple-50" : ""}`,
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "w-10 h-10 rounded-lg overflow-hidden flex-shrink-0 border border-gray-200",
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                            src: getImageUrl(service.image),
                                            alt: service.typeName,
                                            width: 40,
                                            height: 40,
                                            className: "w-full h-full object-cover"
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                            lineNumber: 205,
                                            columnNumber: 21
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                        lineNumber: 204,
                                        columnNumber: 19
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "body-text",
                                        children: service.typeName
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                        lineNumber: 213,
                                        columnNumber: 19
                                    }, this)
                                ]
                            }, service.id, true, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                lineNumber: 194,
                                columnNumber: 17
                            }, this)) : searchQuery.trim().length > 0 ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "p-4 text-center text-gray-500 text-sm",
                            children: "No services found"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                            lineNumber: 217,
                            columnNumber: 15
                        }, this) : null,
                        searchQuery.trim().length > 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Fragment"], {
                            children: [
                                filteredServices.length > 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "border-t border-gray-200 my-2"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 226,
                                    columnNumber: 19
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "px-4 py-2",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                        className: "heading-6 text-gray-900",
                                        children: "Venues"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                        lineNumber: 229,
                                        columnNumber: 19
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 228,
                                    columnNumber: 17
                                }, this),
                                isLoadingVenues ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "p-4 text-center text-gray-500 text-sm",
                                    children: "Searching venues..."
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 232,
                                    columnNumber: 19
                                }, this) : venues.length === 0 ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "p-4 text-center text-gray-500 text-sm",
                                    children: "No venues found"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                    lineNumber: 236,
                                    columnNumber: 19
                                }, this) : venues.map((venue)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        onClick: ()=>handleVenueClick(venue),
                                        className: "w-full px-4 py-3 text-left hover:bg-gray-50 flex items-center gap-3",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "w-10 h-10 rounded-lg overflow-hidden flex-shrink-0 border border-gray-200 bg-gray-100 flex items-center justify-center",
                                                children: venue.image && venue.image !== "/placeholder-venue" ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                                    src: venue.image,
                                                    alt: venue.name,
                                                    width: 40,
                                                    height: 40,
                                                    className: "w-full h-full object-cover"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                    lineNumber: 248,
                                                    columnNumber: 27
                                                }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__["MapPin"], {
                                                    className: "w-5 h-5 text-gray-400"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                    lineNumber: 256,
                                                    columnNumber: 27
                                                }, this)
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 246,
                                                columnNumber: 23
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex-1 min-w-0",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "body-text truncate",
                                                        children: venue.name
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                        lineNumber: 260,
                                                        columnNumber: 25
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "text-xs text-gray-500 truncate",
                                                        children: venue.location
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                        lineNumber: 261,
                                                        columnNumber: 25
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                                lineNumber: 259,
                                                columnNumber: 23
                                            }, this)
                                        ]
                                    }, venue.id, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                                        lineNumber: 241,
                                        columnNumber: 21
                                    }, this))
                            ]
                        }, void 0, true)
                    ]
                }, void 0, true)
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
                lineNumber: 156,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx",
        lineNumber: 136,
        columnNumber: 5
    }, this);
}
_s(ServiceTypesDropdown, "XRs7OPumEXVAvDPaywv1d4uEl+o=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"]
    ];
});
_c = ServiceTypesDropdown;
var _c;
__turbopack_context__.k.register(_c, "ServiceTypesDropdown");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "LocationSearch",
    ()=>LocationSearch
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/map-pin.js [app-client] (ecmascript) <export default as MapPin>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/env.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
function LocationSearch({ isOpen, onClose, onSelect, selectedLocation }) {
    _s();
    const [searchQuery, setSearchQuery] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])("");
    const [predictions, setPredictions] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const dropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const autocompleteServiceRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LocationSearch.useEffect": ()=>{
            if (isOpen && ("TURBOPACK compile-time value", "object") !== "undefined" && window.google) {
                autocompleteServiceRef.current = new window.google.maps.places.AutocompleteService();
            } else if (isOpen && ("TURBOPACK compile-time value", "object") !== "undefined") {
                // Load Google Maps script if not loaded
                const script = document.createElement("script");
                script.src = `https://maps.googleapis.com/maps/api/js?key=${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["googleApiKey"]}&libraries=places`;
                script.async = true;
                script.defer = true;
                script.onload = ({
                    "LocationSearch.useEffect": ()=>{
                        autocompleteServiceRef.current = new window.google.maps.places.AutocompleteService();
                    }
                })["LocationSearch.useEffect"];
                document.head.appendChild(script);
            }
        }
    }["LocationSearch.useEffect"], [
        isOpen
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LocationSearch.useEffect": ()=>{
            const handleClickOutside = {
                "LocationSearch.useEffect.handleClickOutside": (event)=>{
                    if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
                        onClose();
                    }
                }
            }["LocationSearch.useEffect.handleClickOutside"];
            if (isOpen) {
                document.addEventListener("mousedown", handleClickOutside);
            }
            return ({
                "LocationSearch.useEffect": ()=>{
                    document.removeEventListener("mousedown", handleClickOutside);
                }
            })["LocationSearch.useEffect"];
        }
    }["LocationSearch.useEffect"], [
        isOpen,
        onClose
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LocationSearch.useEffect": ()=>{
            if (!searchQuery || !autocompleteServiceRef.current) {
                setPredictions([]);
                return;
            }
            const timer = setTimeout({
                "LocationSearch.useEffect.timer": ()=>{
                    setIsLoading(true);
                    autocompleteServiceRef.current?.getPlacePredictions({
                        input: searchQuery,
                        types: [
                            "(cities)"
                        ]
                    }, {
                        "LocationSearch.useEffect.timer": (predictions, status)=>{
                            setIsLoading(false);
                            if (status === google.maps.places.PlacesServiceStatus.OK && predictions) {
                                setPredictions(predictions);
                            } else {
                                setPredictions([]);
                            }
                        }
                    }["LocationSearch.useEffect.timer"]);
                }
            }["LocationSearch.useEffect.timer"], 300);
            return ({
                "LocationSearch.useEffect": ()=>clearTimeout(timer)
            })["LocationSearch.useEffect"];
        }
    }["LocationSearch.useEffect"], [
        searchQuery
    ]);
    const handleSelectPrediction = (prediction)=>{
        const geocoder = new google.maps.Geocoder();
        geocoder.geocode({
            placeId: prediction.place_id
        }, (results, status)=>{
            if (status === "OK" && results && results[0]) {
                const location = results[0].geometry.location;
                onSelect({
                    name: prediction.description,
                    lat: location.lat(),
                    lng: location.lng()
                });
                onClose();
            }
        });
    };
    if (!isOpen) return null;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        ref: dropdownRef,
        className: "absolute top-full left-0 mt-2 bg-white rounded-xl shadow-lg border border-gray-200 z-50 max-h-96 overflow-hidden flex flex-col",
        style: {
            width: "312px"
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "p-4 border-b border-gray-200",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__["MapPin"], {
                            className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                            lineNumber: 114,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                            type: "text",
                            placeholder: "Search location...",
                            value: searchQuery,
                            onChange: (e)=>setSearchQuery(e.target.value),
                            className: "w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                            lineNumber: 115,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                    lineNumber: 113,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                lineNumber: 112,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "overflow-y-auto flex-1",
                children: isLoading ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "p-8 text-center text-gray-500",
                    children: "Searching..."
                }, void 0, false, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                    lineNumber: 128,
                    columnNumber: 11
                }, this) : predictions.length === 0 && searchQuery ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "p-8 text-center text-gray-500",
                    children: "No locations found"
                }, void 0, false, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                    lineNumber: 130,
                    columnNumber: 11
                }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Fragment"], {
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            onClick: ()=>{
                                if (navigator.geolocation) {
                                    navigator.geolocation.getCurrentPosition((position)=>{
                                        onSelect({
                                            name: "Current location",
                                            lat: position.coords.latitude,
                                            lng: position.coords.longitude
                                        });
                                        onClose();
                                    }, ()=>{
                                        onSelect(null);
                                        onClose();
                                    });
                                } else {
                                    onSelect(null);
                                    onClose();
                                }
                            },
                            className: `w-full px-4 py-3 text-left hover:bg-gray-50 flex items-center gap-3 ${selectedLocation?.name === "Current location" ? "bg-purple-50" : ""}`,
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__["MapPin"], {
                                    className: "w-5 h-5 text-gray-500"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                    lineNumber: 160,
                                    columnNumber: 15
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: "body-text",
                                    children: "Current location"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                    lineNumber: 161,
                                    columnNumber: 15
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                            lineNumber: 134,
                            columnNumber: 13
                        }, this),
                        predictions.map((prediction)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>handleSelectPrediction(prediction),
                                className: "w-full px-4 py-3 text-left hover:bg-gray-50 flex items-center gap-3",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__["MapPin"], {
                                        className: "w-5 h-5 text-gray-500"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                        lineNumber: 171,
                                        columnNumber: 17
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex flex-col",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "body-text",
                                                children: prediction.structured_formatting.main_text
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                                lineNumber: 173,
                                                columnNumber: 19
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "body-text-sm text-gray-500",
                                                children: prediction.structured_formatting.secondary_text
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                                lineNumber: 174,
                                                columnNumber: 19
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                        lineNumber: 172,
                                        columnNumber: 17
                                    }, this)
                                ]
                            }, prediction.place_id, true, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                                lineNumber: 166,
                                columnNumber: 15
                            }, this))
                    ]
                }, void 0, true)
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
                lineNumber: 126,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx",
        lineNumber: 106,
        columnNumber: 5
    }, this);
}
_s(LocationSearch, "SvvNBEWU0UyeDV9cwbFlzx89RPo=");
_c = LocationSearch;
var _c;
__turbopack_context__.k.register(_c, "LocationSearch");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "DatePicker",
    ()=>DatePicker
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-left.js [app-client] (ecmascript) <export default as ChevronLeft>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-right.js [app-client] (ecmascript) <export default as ChevronRight>");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
function DatePicker({ isOpen, onClose, onSelect, selectedDate }) {
    _s();
    const [currentMonth, setCurrentMonth] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(new Date());
    const [selectedDay, setSelectedDay] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(selectedDate?.type === "date" ? selectedDate.date || null : null);
    const dropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "DatePicker.useEffect": ()=>{
            const handleClickOutside = {
                "DatePicker.useEffect.handleClickOutside": (event)=>{
                    if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
                        onClose();
                    }
                }
            }["DatePicker.useEffect.handleClickOutside"];
            if (isOpen) {
                document.addEventListener("mousedown", handleClickOutside);
            }
            return ({
                "DatePicker.useEffect": ()=>{
                    document.removeEventListener("mousedown", handleClickOutside);
                }
            })["DatePicker.useEffect"];
        }
    }["DatePicker.useEffect"], [
        isOpen,
        onClose
    ]);
    const today = new Date();
    const tomorrow = new Date(today);
    tomorrow.setDate(tomorrow.getDate() + 1);
    const getDaysInMonth = (date)=>{
        const year = date.getFullYear();
        const month = date.getMonth();
        const firstDay = new Date(year, month, 1);
        const lastDay = new Date(year, month + 1, 0);
        const daysInMonth = lastDay.getDate();
        const startingDayOfWeek = firstDay.getDay();
        // Adjust to start from Monday (0 = Monday)
        const adjustedStartingDay = startingDayOfWeek === 0 ? 6 : startingDayOfWeek - 1;
        return {
            daysInMonth,
            startingDayOfWeek: adjustedStartingDay
        };
    };
    const { daysInMonth, startingDayOfWeek } = getDaysInMonth(currentMonth);
    const handleQuickSelect = (type)=>{
        if (type === "any") {
            onSelect({
                type: "any"
            });
        } else if (type === "today") {
            onSelect({
                type: "today",
                date: today
            });
        } else if (type === "tomorrow") {
            onSelect({
                type: "tomorrow",
                date: tomorrow
            });
        }
        onClose();
    };
    const handleDateSelect = (day)=>{
        const selected = new Date(currentMonth.getFullYear(), currentMonth.getMonth(), day);
        setSelectedDay(selected);
        onSelect({
            type: "date",
            date: selected
        });
        onClose();
    };
    const isToday = (day)=>{
        const date = new Date(currentMonth.getFullYear(), currentMonth.getMonth(), day);
        return date.toDateString() === today.toDateString();
    };
    const isTomorrow = (day)=>{
        const date = new Date(currentMonth.getFullYear(), currentMonth.getMonth(), day);
        return date.toDateString() === tomorrow.toDateString();
    };
    const isSelected = (day)=>{
        if (!selectedDay) return false;
        const date = new Date(currentMonth.getFullYear(), currentMonth.getMonth(), day);
        return date.toDateString() === selectedDay.toDateString();
    };
    const monthNames = [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December"
    ];
    const dayNames = [
        "Mon",
        "Tue",
        "Wed",
        "Thu",
        "Fri",
        "Sat",
        "Sun"
    ];
    const navigateMonth = (direction)=>{
        setCurrentMonth((prev)=>{
            const newDate = new Date(prev);
            if (direction === "prev") {
                newDate.setMonth(prev.getMonth() - 1);
            } else {
                newDate.setMonth(prev.getMonth() + 1);
            }
            return newDate;
        });
    };
    if (!isOpen) return null;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        ref: dropdownRef,
        className: "bg-white rounded-2xl shadow-xl border border-gray-200 z-50 p-6",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "flex flex-col lg:flex-row gap-6",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex flex-row lg:flex-col gap-3",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            onClick: ()=>handleQuickSelect("today"),
                            className: `px-4 py-3 rounded-xl text-sm font-medium transition-all text-left lg:min-w-[160px] ${selectedDate?.type === "today" ? "bg-purple-600 text-white border-2 border-purple-600" : "bg-white border-2 border-gray-200 text-gray-700 hover:border-gray-300"}`,
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "font-semibold",
                                    children: "Today"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 151,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: `text-xs ${selectedDate?.type === "today" ? "text-purple-100" : "text-gray-500"}`,
                                    children: today.toLocaleDateString("en-US", {
                                        weekday: "short",
                                        day: "numeric",
                                        month: "short"
                                    })
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 152,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                            lineNumber: 143,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            onClick: ()=>handleQuickSelect("tomorrow"),
                            className: `px-4 py-3 rounded-xl text-sm font-medium transition-all text-left lg:min-w-[160px] ${selectedDate?.type === "tomorrow" ? "bg-purple-600 text-white border-2 border-purple-600" : "bg-white border-2 border-gray-200 text-gray-700 hover:border-gray-300"}`,
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "font-semibold",
                                    children: "Tomorrow"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 164,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: `text-xs ${selectedDate?.type === "tomorrow" ? "text-purple-100" : "text-gray-500"}`,
                                    children: tomorrow.toLocaleDateString("en-US", {
                                        weekday: "short",
                                        day: "numeric",
                                        month: "short"
                                    })
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 165,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                            lineNumber: 156,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                    lineNumber: 142,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex-1",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex items-center justify-between mb-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                    onClick: ()=>navigateMonth("prev"),
                                    className: "p-2 hover:bg-gray-100 rounded-lg transition-colors",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__["ChevronLeft"], {
                                        className: "w-5 h-5 text-gray-600"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                        lineNumber: 179,
                                        columnNumber: 15
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 175,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                    className: "text-lg font-semibold text-gray-900",
                                    children: currentMonth.toLocaleDateString("en-US", {
                                        month: "long",
                                        year: "numeric"
                                    })
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 181,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                    onClick: ()=>navigateMonth("next"),
                                    className: "p-2 hover:bg-gray-100 rounded-lg transition-colors",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                                        className: "w-5 h-5 text-gray-600"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                        lineNumber: 188,
                                        columnNumber: 15
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 184,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                            lineNumber: 174,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "grid grid-cols-7 gap-1 mb-2",
                            children: dayNames.map((day)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "text-center text-xs font-medium text-gray-500 py-2",
                                    children: day
                                }, day, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                    lineNumber: 195,
                                    columnNumber: 15
                                }, this))
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                            lineNumber: 193,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "grid grid-cols-7 gap-1",
                            children: [
                                Array.from({
                                    length: startingDayOfWeek
                                }).map((_, index)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "aspect-square"
                                    }, `empty-${index}`, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                        lineNumber: 206,
                                        columnNumber: 15
                                    }, this)),
                                Array.from({
                                    length: daysInMonth
                                }).map((_, index)=>{
                                    const day = index + 1;
                                    const isSelectedDay = isSelected(day);
                                    const isTodayDay = isToday(day);
                                    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        onClick: ()=>handleDateSelect(day),
                                        className: `aspect-square rounded-full text-sm font-medium transition-all ${isSelectedDay ? "bg-purple-600 text-white" : isTodayDay ? "bg-purple-50 text-purple-700 border border-purple-200" : "text-gray-700 hover:bg-gray-50"}`,
                                        children: day
                                    }, day, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                                        lineNumber: 214,
                                        columnNumber: 17
                                    }, this);
                                })
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                            lineNumber: 204,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
                    lineNumber: 172,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
            lineNumber: 140,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx",
        lineNumber: 136,
        columnNumber: 5
    }, this);
}
_s(DatePicker, "coTinvb1nFN/6KeDpRfy9kvOC/4=");
_c = DatePicker;
var _c;
__turbopack_context__.k.register(_c, "DatePicker");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "TimePicker",
    ()=>TimePicker
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDown$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-down.js [app-client] (ecmascript) <export default as ChevronDown>");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
const timeOptions = [
    "12:00 am",
    "12:30 am",
    "1:00 am",
    "1:30 am",
    "2:00 am",
    "2:30 am",
    "3:00 am",
    "3:30 am",
    "4:00 am",
    "4:30 am",
    "5:00 am",
    "5:30 am",
    "6:00 am",
    "6:30 am",
    "7:00 am",
    "7:30 am",
    "8:00 am",
    "8:30 am",
    "9:00 am",
    "9:30 am",
    "10:00 am",
    "10:30 am",
    "11:00 am",
    "11:30 am",
    "12:00 pm",
    "12:30 pm",
    "1:00 pm",
    "1:30 pm",
    "2:00 pm",
    "2:30 pm",
    "3:00 pm",
    "3:30 pm",
    "4:00 pm",
    "4:30 pm",
    "5:00 pm",
    "5:30 pm",
    "6:00 pm",
    "6:30 pm",
    "7:00 pm",
    "7:30 pm",
    "8:00 pm",
    "8:30 pm",
    "9:00 pm",
    "9:30 pm",
    "10:00 pm",
    "10:30 pm",
    "11:00 pm",
    "11:30 pm"
];
const defaultTimeRanges = {
    morning: {
        from: "6:00 am",
        to: "12:00 pm"
    },
    afternoon: {
        from: "12:00 pm",
        to: "6:00 pm"
    },
    evening: {
        from: "6:00 pm",
        to: "11:00 pm"
    }
};
function TimePicker({ isOpen, onClose, onSelect, selectedTime }) {
    _s();
    const [period, setPeriod] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(selectedTime?.period || "any");
    const [fromTime, setFromTime] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(selectedTime?.from || "6:00 am");
    const [toTime, setToTime] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(selectedTime?.to || "12:00 pm");
    const [fromDropdownOpen, setFromDropdownOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [toDropdownOpen, setToDropdownOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const dropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const fromDropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const toDropdownRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "TimePicker.useEffect": ()=>{
            const handleClickOutside = {
                "TimePicker.useEffect.handleClickOutside": (event)=>{
                    if (dropdownRef.current && !dropdownRef.current.contains(event.target) && fromDropdownRef.current && !fromDropdownRef.current.contains(event.target) && toDropdownRef.current && !toDropdownRef.current.contains(event.target)) {
                        onClose();
                    }
                }
            }["TimePicker.useEffect.handleClickOutside"];
            if (isOpen) {
                document.addEventListener("mousedown", handleClickOutside);
            }
            return ({
                "TimePicker.useEffect": ()=>{
                    document.removeEventListener("mousedown", handleClickOutside);
                }
            })["TimePicker.useEffect"];
        }
    }["TimePicker.useEffect"], [
        isOpen,
        onClose
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "TimePicker.useEffect": ()=>{
            if (period !== "any" && defaultTimeRanges[period]) {
                const range = defaultTimeRanges[period];
                setFromTime(range.from);
                setToTime(range.to);
                // Auto-select when period changes
                onSelect({
                    period: period,
                    from: range.from,
                    to: range.to
                });
            }
        // eslint-disable-next-line react-hooks/exhaustive-deps
        }
    }["TimePicker.useEffect"], [
        period
    ]);
    const handlePeriodSelect = (selectedPeriod)=>{
        setPeriod(selectedPeriod);
        if (selectedPeriod === "any") {
            onSelect({
                period: "any"
            });
            onClose();
        } else {
            const range = defaultTimeRanges[selectedPeriod];
            setFromTime(range.from);
            setToTime(range.to);
        }
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "TimePicker.useEffect": ()=>{
            // Auto-update when time range changes manually (but not on initial period set)
            if (period !== "any" && fromTime && toTime) {
                const timer = setTimeout({
                    "TimePicker.useEffect.timer": ()=>{
                        onSelect({
                            period: period,
                            from: fromTime,
                            to: toTime
                        });
                    }
                }["TimePicker.useEffect.timer"], 300);
                return ({
                    "TimePicker.useEffect": ()=>clearTimeout(timer)
                })["TimePicker.useEffect"];
            }
        // eslint-disable-next-line react-hooks/exhaustive-deps
        }
    }["TimePicker.useEffect"], [
        fromTime,
        toTime
    ]);
    const handleTimeRangeSelect = ()=>{
        onSelect({
            period: period === "any" ? undefined : period,
            from: fromTime,
            to: toTime
        });
        onClose();
    };
    const getDisplayText = ()=>{
        if (!selectedTime || selectedTime.period === "any") return "Any time";
        if (selectedTime.period) {
            return `${selectedTime.from || "6:00 am"} - ${selectedTime.to || "12:00 pm"}`;
        }
        if (selectedTime.from && selectedTime.to) {
            return `${selectedTime.from} - ${selectedTime.to}`;
        }
        return "Any time";
    };
    if (!isOpen) return null;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        ref: dropdownRef,
        className: "absolute top-full left-0 mt-2 bg-white rounded-xl shadow-lg border border-gray-200 z-50 p-4",
        style: {
            width: "312px"
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex gap-2 mb-4",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>handlePeriodSelect("any"),
                        className: `px-4 py-2 rounded-full text-sm font-medium transition-colors ${period === "any" ? "bg-purple-600 text-white" : "bg-white border border-gray-300 text-gray-700 hover:bg-gray-50"}`,
                        children: "Any time"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 194,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>handlePeriodSelect("morning"),
                        className: `px-4 py-2 rounded-full text-sm font-medium transition-colors ${period === "morning" ? "bg-purple-600 text-white" : "bg-white border border-gray-300 text-gray-700 hover:bg-gray-50"}`,
                        children: "Morning"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 204,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>handlePeriodSelect("afternoon"),
                        className: `px-4 py-2 rounded-full text-sm font-medium transition-colors ${period === "afternoon" ? "bg-purple-600 text-white" : "bg-white border border-gray-300 text-gray-700 hover:bg-gray-50"}`,
                        children: "Afternoon"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 214,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>handlePeriodSelect("evening"),
                        className: `px-4 py-2 rounded-full text-sm font-medium transition-colors ${period === "evening" ? "bg-purple-600 text-white" : "bg-white border border-gray-300 text-gray-700 hover:bg-gray-50"}`,
                        children: "Evening"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 224,
                        columnNumber: 9
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                lineNumber: 193,
                columnNumber: 7
            }, this),
            period !== "any" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex gap-3 items-center mb-2",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative flex-1",
                        ref: fromDropdownRef,
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>{
                                    setFromDropdownOpen(!fromDropdownOpen);
                                    setToDropdownOpen(false);
                                },
                                className: "w-full px-4 py-2 border border-gray-300 rounded-lg text-left flex items-center justify-between hover:bg-gray-50",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "body-text-sm text-gray-500",
                                        children: "From"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 247,
                                        columnNumber: 15
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex items-center gap-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "body-text",
                                                children: fromTime
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                                lineNumber: 249,
                                                columnNumber: 17
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDown$3e$__["ChevronDown"], {
                                                className: "w-4 h-4 text-gray-400"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                                lineNumber: 250,
                                                columnNumber: 17
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 248,
                                        columnNumber: 15
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                lineNumber: 240,
                                columnNumber: 13
                            }, this),
                            fromDropdownOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "absolute top-full left-0 right-0 mt-1 bg-white border border-gray-200 rounded-lg shadow-lg max-h-60 overflow-y-auto z-10",
                                children: timeOptions.map((time)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        onClick: ()=>{
                                            setFromTime(time);
                                            setFromDropdownOpen(false);
                                        },
                                        className: `w-full px-4 py-2 text-left hover:bg-gray-50 ${fromTime === time ? "bg-purple-50" : ""}`,
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "body-text-sm",
                                            children: time
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                            lineNumber: 266,
                                            columnNumber: 21
                                        }, this)
                                    }, time, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 256,
                                        columnNumber: 19
                                    }, this))
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                lineNumber: 254,
                                columnNumber: 15
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 239,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative flex-1",
                        ref: toDropdownRef,
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>{
                                    setToDropdownOpen(!toDropdownOpen);
                                    setFromDropdownOpen(false);
                                },
                                className: "w-full px-4 py-2 border border-gray-300 rounded-lg text-left flex items-center justify-between hover:bg-gray-50",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "body-text-sm text-gray-500",
                                        children: "To"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 281,
                                        columnNumber: 15
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex items-center gap-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "body-text",
                                                children: toTime
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                                lineNumber: 283,
                                                columnNumber: 17
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDown$3e$__["ChevronDown"], {
                                                className: "w-4 h-4 text-gray-400"
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                                lineNumber: 284,
                                                columnNumber: 17
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 282,
                                        columnNumber: 15
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                lineNumber: 274,
                                columnNumber: 13
                            }, this),
                            toDropdownOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "absolute top-full left-0 right-0 mt-1 bg-white border border-gray-200 rounded-lg shadow-lg max-h-60 overflow-y-auto z-10",
                                children: timeOptions.map((time)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        onClick: ()=>{
                                            setToTime(time);
                                            setToDropdownOpen(false);
                                        },
                                        className: `w-full px-4 py-2 text-left hover:bg-gray-50 ${toTime === time ? "bg-purple-50" : ""}`,
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "body-text-sm",
                                            children: time
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                            lineNumber: 300,
                                            columnNumber: 21
                                        }, this)
                                    }, time, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                        lineNumber: 290,
                                        columnNumber: 19
                                    }, this))
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                                lineNumber: 288,
                                columnNumber: 15
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                        lineNumber: 273,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
                lineNumber: 238,
                columnNumber: 9
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx",
        lineNumber: 187,
        columnNumber: 5
    }, this);
}
_s(TimePicker, "Mo1Hd5R6j1Qy1DCilxTA/fH7saM=");
_c = TimePicker;
var _c;
__turbopack_context__.k.register(_c, "TimePicker");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "HeroSection",
    ()=>HeroSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/search.js [app-client] (ecmascript) <export default as Search>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/map-pin.js [app-client] (ecmascript) <export default as MapPin>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$calendar$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Calendar$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/calendar.js [app-client] (ecmascript) <export default as Calendar>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$ServiceTypesDropdown$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/search/components/ServiceTypesDropdown.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$LocationSearch$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/search/components/LocationSearch.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$DatePicker$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/search/components/DatePicker.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$TimePicker$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/search/components/TimePicker.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
;
function HeroSection() {
    _s();
    const router = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"])();
    const [serviceDropdownOpen, setServiceDropdownOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [locationDropdownOpen, setLocationDropdownOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [datePickerOpen, setDatePickerOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [timePickerOpen, setTimePickerOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [selectedService, setSelectedService] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [selectedLocation, setSelectedLocation] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [selectedDate, setSelectedDate] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [selectedTime, setSelectedTime] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    // Get default location or use geolocation
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "HeroSection.useEffect": ()=>{
            if (!selectedLocation && navigator.geolocation) {
                navigator.geolocation.getCurrentPosition({
                    "HeroSection.useEffect": (position)=>{
                        setSelectedLocation({
                            name: "Current location",
                            lat: position.coords.latitude,
                            lng: position.coords.longitude
                        });
                    }
                }["HeroSection.useEffect"], {
                    "HeroSection.useEffect": ()=>{
                        // Fallback to default location
                        setSelectedLocation({
                            name: "Current location",
                            lat: 31.462576,
                            lng: 74.247932
                        });
                    }
                }["HeroSection.useEffect"]);
            } else if (!selectedLocation) {
                setSelectedLocation({
                    name: "Current location",
                    lat: 31.462576,
                    lng: 74.247932
                });
            }
        }
    }["HeroSection.useEffect"], []);
    const handleSearch = ()=>{
        const params = new URLSearchParams();
        if (selectedLocation) {
            params.set("lat", selectedLocation.lat.toString());
            params.set("lng", selectedLocation.lng.toString());
        } else {
            // Use default location if not selected
            params.set("lat", "31.462576");
            params.set("lng", "74.247932");
        }
        if (selectedService) {
            params.set("serviceType", selectedService.id.toString());
        }
        if (selectedDate && selectedDate.type !== "any" && selectedDate.date) {
            const dayNames = [
                "Sunday",
                "Monday",
                "Tuesday",
                "Wednesday",
                "Thursday",
                "Friday",
                "Saturday"
            ];
            params.set("day", dayNames[selectedDate.date.getDay()]);
        }
        if (selectedTime && selectedTime.from && selectedTime.to) {
            // Convert time to 24-hour format for API
            const from24 = convertTo24Hour(selectedTime.from);
            params.set("time", from24);
        }
        router.push(`/search?${params.toString()}`);
    };
    const convertTo24Hour = (time12)=>{
        const [time, period] = time12.split(" ");
        const [hours, minutes] = time.split(":");
        let hour24 = parseInt(hours);
        if (period === "pm" && hour24 !== 12) hour24 += 12;
        if (period === "am" && hour24 === 12) hour24 = 0;
        return `${hour24.toString().padStart(2, "0")}:${minutes}:00`;
    };
    const getDateDisplayText = ()=>{
        if (!selectedDate) return "Any date";
        if (selectedDate.type === "any") return "Any date";
        if (selectedDate.type === "today") return "Today";
        if (selectedDate.type === "tomorrow") return "Tomorrow";
        if (selectedDate.type === "date" && selectedDate.date) {
            return selectedDate.date.toLocaleDateString("en-US", {
                weekday: "short",
                month: "short",
                day: "numeric"
            });
        }
        return "Any date";
    };
    const getTimeDisplayText = ()=>{
        if (!selectedTime || selectedTime.period === "any") return "Any time";
        if (selectedTime.from && selectedTime.to) {
            return `${selectedTime.from} - ${selectedTime.to}`;
        }
        return "Any time";
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("section", {
        className: "relative min-h-[50vh] sm:min-h-[60vh] md:min-h-[70vh] lg:min-h-[80vh] flex items-center justify-center pt-12 sm:pt-16 md:pt-20 pb-6 sm:pb-8 md:pb-12 px-2 sm:px-4 bg-gradient-to-b from-purple-50 via-pink-50 to-white",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            className: "relative z-10",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "text-center mb-6 sm:mb-8 md:mb-10",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h1", {
                            className: "text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold mb-3 sm:mb-4 px-2",
                            style: {
                                color: "var(--text-primary)"
                            },
                            children: "Book local selfcare services"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                            lineNumber: 136,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                            className: "text-sm sm:text-base md:text-lg max-w-4xl mx-auto px-2 sm:px-4",
                            style: {
                                color: "var(--text-secondary)"
                            },
                            children: "Discover top-rated salons, barbers, medspas, wellness studios and beauty experts trusted by millions worldwide."
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                            lineNumber: 142,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                    lineNumber: 135,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "max-w-4xl mx-auto mb-4 sm:mb-6 px-2",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "relative flex flex-col lg:flex-row items-stretch lg:items-center bg-white rounded-2xl lg:rounded-full shadow-md lg:p-2",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative flex-1",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "relative",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                type: "button",
                                                onClick: ()=>{
                                                    setServiceDropdownOpen(!serviceDropdownOpen);
                                                    setLocationDropdownOpen(false);
                                                    setDatePickerOpen(false);
                                                },
                                                className: "w-full pl-12 pr-4 py-4 lg:py-3.5 text-left hover:bg-gray-50 lg:rounded-l-full transition-colors text-sm sm:text-base text-gray-900 focus:outline-none focus:ring-0 border-0 flex items-center relative",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__["Search"], {
                                                        className: "absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500 pointer-events-none"
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                        lineNumber: 166,
                                                        columnNumber: 19
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                        className: "flex-1 truncate",
                                                        children: selectedService ? selectedService.typeName : "All treatments and venues"
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                        lineNumber: 167,
                                                        columnNumber: 19
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                lineNumber: 157,
                                                columnNumber: 17
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 156,
                                            columnNumber: 15
                                        }, this),
                                        serviceDropdownOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute left-0 right-0 lg:left-0 lg:right-0 top-full mt-2 z-50",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$ServiceTypesDropdown$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ServiceTypesDropdown"], {
                                                isOpen: serviceDropdownOpen,
                                                onClose: ()=>setServiceDropdownOpen(false),
                                                onSelect: (service)=>{
                                                    setSelectedService(service);
                                                    setServiceDropdownOpen(false);
                                                },
                                                selectedService: selectedService,
                                                location: selectedLocation
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                lineNumber: 176,
                                                columnNumber: 19
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 175,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 155,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "lg:hidden h-px bg-gray-200"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 191,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "hidden lg:block w-px h-8 bg-gray-300 self-center"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 192,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative flex-1",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                            onClick: ()=>{
                                                setLocationDropdownOpen(!locationDropdownOpen);
                                                setServiceDropdownOpen(false);
                                                setDatePickerOpen(false);
                                            },
                                            className: "w-full flex items-center gap-3 px-4 py-4 lg:py-3.5 text-left hover:bg-gray-50 transition-colors border-0 text-sm sm:text-base",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$map$2d$pin$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MapPin$3e$__["MapPin"], {
                                                    className: "w-5 h-5 text-gray-500 flex-shrink-0"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                    lineNumber: 204,
                                                    columnNumber: 17
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                    className: "flex-1 text-gray-900 truncate",
                                                    children: selectedLocation ? selectedLocation.name : "Current location"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                    lineNumber: 205,
                                                    columnNumber: 17
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 196,
                                            columnNumber: 15
                                        }, this),
                                        locationDropdownOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute left-0 right-0 lg:left-0 lg:right-0 top-full mt-2 z-50",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$LocationSearch$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LocationSearch"], {
                                                isOpen: locationDropdownOpen,
                                                onClose: ()=>setLocationDropdownOpen(false),
                                                onSelect: setSelectedLocation,
                                                selectedLocation: selectedLocation
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                lineNumber: 213,
                                                columnNumber: 19
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 212,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 195,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "lg:hidden h-px bg-gray-200"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 224,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "hidden lg:block w-px h-8 bg-gray-300 self-center"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 225,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative flex-1",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                            onClick: ()=>{
                                                setDatePickerOpen(!datePickerOpen);
                                                setServiceDropdownOpen(false);
                                                setLocationDropdownOpen(false);
                                            },
                                            className: "w-full flex items-center gap-3 px-4 py-4 lg:py-3.5 text-left hover:bg-gray-50 transition-colors border-0 text-sm sm:text-base",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$calendar$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Calendar$3e$__["Calendar"], {
                                                    className: "w-5 h-5 text-gray-500 flex-shrink-0"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                    lineNumber: 237,
                                                    columnNumber: 17
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                    className: "flex-1 text-gray-900 truncate",
                                                    children: selectedDate && selectedDate.type !== "any" ? `${getDateDisplayText()}${selectedTime && selectedTime.period !== "any" ? ` · ${getTimeDisplayText()}` : " · Any time"}` : "Today · Any time"
                                                }, void 0, false, {
                                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                    lineNumber: 238,
                                                    columnNumber: 17
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 229,
                                            columnNumber: 15
                                        }, this),
                                        datePickerOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute left-0 right-0 lg:left-auto lg:right-0 lg:w-[600px] top-full mt-2 z-50",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "bg-white rounded-2xl shadow-xl p-6",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$DatePicker$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["DatePicker"], {
                                                        isOpen: datePickerOpen,
                                                        onClose: ()=>setDatePickerOpen(false),
                                                        onSelect: setSelectedDate,
                                                        selectedDate: selectedDate
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                        lineNumber: 252,
                                                        columnNumber: 21
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "mt-6 pt-6 border-t border-gray-200",
                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$search$2f$components$2f$TimePicker$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["TimePicker"], {
                                                            isOpen: true,
                                                            onClose: ()=>{},
                                                            onSelect: setSelectedTime,
                                                            selectedTime: selectedTime
                                                        }, void 0, false, {
                                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                            lineNumber: 261,
                                                            columnNumber: 23
                                                        }, this)
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                        lineNumber: 260,
                                                        columnNumber: 21
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                                lineNumber: 250,
                                                columnNumber: 19
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 249,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 228,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "lg:hidden h-px bg-gray-200"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 274,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                    onClick: handleSearch,
                                    className: "w-full lg:w-auto px-8 py-4 lg:py-3.5 bg-black text-white rounded-b-2xl lg:rounded-full hover:bg-gray-800 transition-colors flex items-center gap-2 justify-center whitespace-nowrap text-sm sm:text-base font-medium",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "lg:hidden",
                                            children: "Search Fresha"
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 281,
                                            columnNumber: 15
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "hidden lg:inline",
                                            children: "Search"
                                        }, void 0, false, {
                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                            lineNumber: 282,
                                            columnNumber: 15
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 277,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                            lineNumber: 153,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                            className: "text-sm sm:text-base text-center mt-4 sm:mt-6",
                            style: {
                                color: "var(--text-secondary)"
                            },
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: "font-bold",
                                    children: "298,347"
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                    lineNumber: 291,
                                    columnNumber: 13
                                }, this),
                                " appointments booked today"
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                            lineNumber: 287,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                    lineNumber: 152,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "text-center mt-6 sm:mt-8",
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        className: "px-4 py-2 sm:px-6 sm:py-3 bg-white border border-gray-300 rounded-xl hover:bg-gray-50 transition-colors inline-flex items-center gap-2 text-sm sm:text-base",
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                children: "Get the app"
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                lineNumber: 298,
                                columnNumber: 13
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "flex gap-0.5 items-center",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "w-3 h-3 sm:w-3.5 sm:h-3.5 border border-gray-400 rounded-sm"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                        lineNumber: 300,
                                        columnNumber: 15
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "w-3 h-3 sm:w-3.5 sm:h-3.5 border border-gray-400 rounded-sm -ml-1"
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                        lineNumber: 301,
                                        columnNumber: 15
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                                lineNumber: 299,
                                columnNumber: 13
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                        lineNumber: 297,
                        columnNumber: 11
                    }, this)
                }, void 0, false, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
                    lineNumber: 296,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
            lineNumber: 133,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/HeroSection.tsx",
        lineNumber: 132,
        columnNumber: 5
    }, this);
}
_s(HeroSection, "n0w1epba5604SdsVHsuYuzpI4gE=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"]
    ];
});
_c = HeroSection;
var _c;
__turbopack_context__.k.register(_c, "HeroSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "HorizontalCarousel",
    ()=>HorizontalCarousel
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-left.js [app-client] (ecmascript) <export default as ChevronLeft>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-right.js [app-client] (ecmascript) <export default as ChevronRight>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
function HorizontalCarousel({ children, title, className = "", seeMoreLink }) {
    _s();
    const scrollRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [showLeftArrow, setShowLeftArrow] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [showRightArrow, setShowRightArrow] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    const checkScrollPosition = ()=>{
        if (scrollRef.current) {
            const { scrollLeft, scrollWidth, clientWidth } = scrollRef.current;
            setShowLeftArrow(scrollLeft > 10);
            setShowRightArrow(scrollLeft < scrollWidth - clientWidth - 10);
        }
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "HorizontalCarousel.useEffect": ()=>{
            const element = scrollRef.current;
            if (element) {
                checkScrollPosition();
                element.addEventListener("scroll", checkScrollPosition);
                // Check on resize
                window.addEventListener("resize", checkScrollPosition);
                return ({
                    "HorizontalCarousel.useEffect": ()=>{
                        element.removeEventListener("scroll", checkScrollPosition);
                        window.removeEventListener("resize", checkScrollPosition);
                    }
                })["HorizontalCarousel.useEffect"];
            }
        }
    }["HorizontalCarousel.useEffect"], []);
    const scroll = (direction)=>{
        if (scrollRef.current) {
            const scrollAmount = 400;
            scrollRef.current.scrollBy({
                left: direction === "left" ? -scrollAmount : scrollAmount,
                behavior: "smooth"
            });
        }
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: className,
        children: [
            title && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex items-center justify-between gap-3 mb-6 sm:mb-8",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                        className: "text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold",
                        style: {
                            color: "var(--text-primary)"
                        },
                        children: title
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                        lineNumber: 60,
                        columnNumber: 11
                    }, this),
                    seeMoreLink && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                        href: seeMoreLink,
                        className: "text-sm sm:text-base font-medium hover:underline flex-shrink-0",
                        style: {
                            color: "var(--text-primary)"
                        },
                        children: "See More"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                        lineNumber: 67,
                        columnNumber: 13
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                lineNumber: 59,
                columnNumber: 9
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative",
                children: [
                    showLeftArrow && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>scroll("left"),
                        className: "absolute left-0 top-1/2 -translate-y-1/2 z-10 bg-white rounded-full p-2 md:p-2.5 lg:p-3 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                        "aria-label": "Scroll left",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__["ChevronLeft"], {
                            className: "w-4 h-4 md:w-5 md:h-5 lg:w-6 lg:h-6 text-gray-700"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                            lineNumber: 86,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                        lineNumber: 81,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "overflow-hidden",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            ref: scrollRef,
                            className: "flex gap-3 sm:gap-4 overflow-x-auto scrollbar-hide scroll-smooth pb-4 items-stretch px-2 sm:px-0",
                            style: {
                                scrollbarWidth: "none",
                                msOverflowStyle: "none",
                                WebkitOverflowScrolling: "touch"
                            },
                            children: children
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                            lineNumber: 92,
                            columnNumber: 11
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                        lineNumber: 91,
                        columnNumber: 9
                    }, this),
                    showRightArrow && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>scroll("right"),
                        className: "absolute right-0 top-1/2 -translate-y-1/2 z-10 bg-white rounded-full p-2 md:p-2.5 lg:p-3 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                        "aria-label": "Scroll right",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                            className: "w-4 h-4 md:w-5 md:h-5 lg:w-6 lg:h-6 text-gray-700"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                            lineNumber: 112,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                        lineNumber: 107,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
                lineNumber: 78,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx",
        lineNumber: 57,
        columnNumber: 5
    }, this);
}
_s(HorizontalCarousel, "eVsjPDrVEkSb5BTZW2zYzilrQrI=");
_c = HorizontalCarousel;
var _c;
__turbopack_context__.k.register(_c, "HorizontalCarousel");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/components/ui/card.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Card",
    ()=>Card
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$classNames$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/lib/classNames.ts [app-client] (ecmascript)");
;
;
function Card({ children, className = "", hover = false, style, onClick, onMouseEnter, onMouseLeave }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$lib$2f$classNames$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["cn"])("bg-surface rounded-[var(--card-border-radius)] overflow-hidden flex flex-col", className),
        style: {
            boxShadow: hover ? undefined : "none",
            ...style
        },
        onClick: onClick,
        onMouseEnter: onMouseEnter,
        onMouseLeave: onMouseLeave,
        children: children
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/components/ui/card.tsx",
        lineNumber: 24,
        columnNumber: 5
    }, this);
}
_c = Card;
var _c;
__turbopack_context__.k.register(_c, "Card");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "StarRating",
    ()=>StarRating
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
;
function StarRating({ rating, reviewCount, className = "" }) {
    // Format: ★4.9 (969) - one decimal, smaller muted review count
    // Slightly smaller font than name, single line, no wrap
    const formattedRating = rating.toFixed(1);
    const formattedCount = reviewCount.toLocaleString();
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: `flex items-center gap-0.5 whitespace-nowrap ${className}`,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "text-xs leading-none",
                style: {
                    color: "var(--color-yellow-400)"
                },
                children: "★"
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx",
                lineNumber: 19,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "text-xs font-semibold leading-none",
                style: {
                    color: "var(--text-primary)"
                },
                children: formattedRating
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx",
                lineNumber: 25,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "text-xs leading-none",
                style: {
                    color: "var(--text-muted)"
                },
                children: [
                    "(",
                    formattedCount,
                    ")"
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx",
                lineNumber: 31,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx",
        lineNumber: 18,
        columnNumber: 5
    }, this);
}
_c = StarRating;
var _c;
__turbopack_context__.k.register(_c, "StarRating");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/components/data-display/PlaceholderImage.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "PlaceholderImage",
    ()=>PlaceholderImage
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ImageIcon$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/image.js [app-client] (ecmascript) <export default as ImageIcon>");
"use client";
;
;
function PlaceholderImage({ className = "", style, text = "No Picture Available" }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: `flex flex-col items-center justify-center bg-gray-100 ${className}`,
        style: style,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ImageIcon$3e$__["ImageIcon"], {
                className: "w-12 h-12 mb-2",
                style: {
                    color: "var(--text-secondary)"
                }
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/components/data-display/PlaceholderImage.tsx",
                lineNumber: 21,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                className: "text-sm text-center px-4",
                style: {
                    color: "var(--text-secondary)"
                },
                children: text
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/components/data-display/PlaceholderImage.tsx",
                lineNumber: 22,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/sigitechnologies.cloud/src/components/data-display/PlaceholderImage.tsx",
        lineNumber: 17,
        columnNumber: 5
    }, this);
}
_c = PlaceholderImage;
var _c;
__turbopack_context__.k.register(_c, "PlaceholderImage");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "VenueCard",
    ()=>VenueCard
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/image.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/ui/card.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$data$2d$display$2f$StarRating$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/data-display/StarRating.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$data$2d$display$2f$PlaceholderImage$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/data-display/PlaceholderImage.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
function VenueCard({ venue, fullWidth = false }) {
    _s();
    const [imageError, setImageError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const router = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"])();
    const handleClick = ()=>{
        router.push(`/saloons/${venue.id}`);
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "h-full w-full",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Card"], {
            hover: true,
            className: `flex-shrink-0 ${fullWidth ? "w-full" : "w-[280px] sm:w-[300px] md:w-[320px] lg:w-card"} h-full flex flex-col min-h-[320px] sm:min-h-[340px] md:min-h-card transition-transform cursor-pointer`,
            style: {
                transform: "translateY(0)"
            },
            onClick: handleClick,
            onMouseEnter: (e)=>{
                e.currentTarget.style.transform = "translateY(var(--card-hover-translate))";
            },
            onMouseLeave: (e)=>{
                e.currentTarget.style.transform = "translateY(0)";
            },
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative w-full flex-shrink-0 overflow-hidden h-[180px] sm:h-[200px] md:h-[220px] lg:h-[var(--card-image-height)]",
                    style: {
                        borderTopLeftRadius: "var(--card-border-radius)",
                        borderTopRightRadius: "var(--card-border-radius)"
                    },
                    children: [
                        imageError || !venue.image || venue.image.includes("placeholder") ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$data$2d$display$2f$PlaceholderImage$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PlaceholderImage"], {
                            className: "w-full h-full",
                            style: {
                                borderTopLeftRadius: "var(--card-border-radius)",
                                borderTopRightRadius: "var(--card-border-radius)",
                                borderBottomLeftRadius: "var(--card-border-radius)",
                                borderBottomRightRadius: "var(--card-border-radius)"
                            }
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 50,
                            columnNumber: 13
                        }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                            src: venue.image,
                            alt: venue.name,
                            fill: true,
                            className: "object-cover",
                            style: {
                                borderTopLeftRadius: "var(--card-border-radius)",
                                borderTopRightRadius: "var(--card-border-radius)",
                                borderBottomLeftRadius: "var(--card-border-radius)",
                                borderBottomRightRadius: "var(--card-border-radius)"
                            },
                            onError: ()=>setImageError(true)
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 60,
                            columnNumber: 13
                        }, this),
                        venue.badge && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "absolute top-2 left-2 px-2 py-0.5 bg-white/90 backdrop-blur-sm rounded-full",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: "text-xs font-bold",
                                style: {
                                    color: "var(--text-primary)"
                                },
                                children: venue.badge
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                                lineNumber: 78,
                                columnNumber: 15
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 77,
                            columnNumber: 13
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                    lineNumber: 42,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex flex-col flex-1 py-3 sm:py-4",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex items-start justify-between gap-2 mb-1.5",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                    className: "text-base sm:text-lg font-bold flex-1 min-w-0 line-clamp-1",
                                    style: {
                                        color: "var(--text-primary)"
                                    },
                                    children: venue.name
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                                    lineNumber: 93,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex-shrink-0",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$data$2d$display$2f$StarRating$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["StarRating"], {
                                        rating: venue.rating,
                                        reviewCount: venue.reviewCount
                                    }, void 0, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                                        lineNumber: 102,
                                        columnNumber: 15
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                                    lineNumber: 101,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 91,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                            className: "text-xs sm:text-sm mb-1.5 line-clamp-1 px-0 font-normal",
                            style: {
                                color: "var(--text-secondary)"
                            },
                            children: venue.address || venue.location
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 110,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                            className: "text-xs sm:text-sm mt-2 font-normal",
                            style: {
                                color: "var(--text-muted)"
                            },
                            children: venue.category
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                            lineNumber: 118,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
                    lineNumber: 89,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
            lineNumber: 26,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx",
        lineNumber: 25,
        columnNumber: 5
    }, this);
}
_s(VenueCard, "k1hJFTn3PuUJwTRlMzlgQI+TlPU=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"]
    ];
});
_c = VenueCard;
var _c;
__turbopack_context__.k.register(_c, "VenueCard");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "PageSection",
    ()=>PageSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
;
function PageSection({ children, className = '', background = 'white', style }) {
    const bgClasses = {
        white: 'bg-white',
        gray: 'bg-gray-50',
        gradient: 'bg-gradient-to-b from-pink-100 via-purple-50 to-blue-50/30',
        'gradient-left': 'bg-white'
    };
    const sectionStyle = style || (background === 'gradient-left' ? {
        background: 'linear-gradient(to right, rgba(243, 232, 255, 0.2), rgba(255, 255, 255, 1) 30%)'
    } : undefined);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("section", {
        className: `${bgClasses[background]} ${className} relative`,
        style: sectionStyle,
        children: children
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx",
        lineNumber: 28,
        columnNumber: 5
    }, this);
}
_c = PageSection;
var _c;
__turbopack_context__.k.register(_c, "PageSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/RecommendedSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "RecommendedSection",
    ()=>RecommendedSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/routes.ts [app-client] (ecmascript)");
"use client";
;
;
;
;
;
;
function RecommendedSection({ venues, lat, lng }) {
    if (venues.length === 0) {
        return null;
    }
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PageSection"], {
        background: "gradient-left",
        className: "py-8 sm:py-12 md:py-16",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["HorizontalCarousel"], {
                title: "Near You",
                seeMoreLink: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["routes"].saloonsWithParams("near-you", lat, lng),
                children: venues.map((venue)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["VenueCard"], {
                        venue: venue
                    }, venue.id, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/RecommendedSection.tsx",
                        lineNumber: 33,
                        columnNumber: 13
                    }, this))
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/RecommendedSection.tsx",
                lineNumber: 28,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/RecommendedSection.tsx",
            lineNumber: 27,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/RecommendedSection.tsx",
        lineNumber: 26,
        columnNumber: 5
    }, this);
}
_c = RecommendedSection;
var _c;
__turbopack_context__.k.register(_c, "RecommendedSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/NewToFreshaSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "NewToFreshaSection",
    ()=>NewToFreshaSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/routes.ts [app-client] (ecmascript)");
"use client";
;
;
;
;
;
;
function NewToFreshaSection({ venues, lat, lng }) {
    if (venues.length === 0) {
        return null;
    }
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PageSection"], {
        background: "gradient-left",
        className: "py-8 sm:py-12 md:py-16",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["HorizontalCarousel"], {
                title: "Top rated",
                seeMoreLink: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["routes"].saloonsWithParams("top-rated", lat, lng),
                children: venues.map((venue)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["VenueCard"], {
                        venue: venue
                    }, venue.id, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/NewToFreshaSection.tsx",
                        lineNumber: 33,
                        columnNumber: 13
                    }, this))
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/NewToFreshaSection.tsx",
                lineNumber: 28,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/NewToFreshaSection.tsx",
            lineNumber: 27,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/NewToFreshaSection.tsx",
        lineNumber: 26,
        columnNumber: 5
    }, this);
}
_c = NewToFreshaSection;
var _c;
__turbopack_context__.k.register(_c, "NewToFreshaSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/SpecialistsSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SpecialistsSection",
    ()=>SpecialistsSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/carousel/HorizontalCarousel.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/features/home/components/VenueCard.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/routes.ts [app-client] (ecmascript)");
"use client";
;
;
;
;
;
;
function SpecialistsSection({ venues, lat, lng }) {
    if (venues.length === 0) {
        return null;
    }
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PageSection"], {
        background: "gradient-left",
        className: "py-8 sm:py-12 md:py-16",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$carousel$2f$HorizontalCarousel$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["HorizontalCarousel"], {
                title: "Specialists",
                seeMoreLink: __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$routes$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["routes"].saloonsWithParams("specialists", lat, lng),
                children: venues.map((venue)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$features$2f$home$2f$components$2f$VenueCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["VenueCard"], {
                        venue: venue
                    }, venue.id, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/SpecialistsSection.tsx",
                        lineNumber: 33,
                        columnNumber: 13
                    }, this))
            }, void 0, false, {
                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/SpecialistsSection.tsx",
                lineNumber: 28,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/SpecialistsSection.tsx",
            lineNumber: 27,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/SpecialistsSection.tsx",
        lineNumber: 26,
        columnNumber: 5
    }, this);
}
_c = SpecialistsSection;
var _c;
__turbopack_context__.k.register(_c, "SpecialistsSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ReviewsSection",
    ()=>ReviewsSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$star$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Star$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/star.js [app-client] (ecmascript) <export default as Star>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-left.js [app-client] (ecmascript) <export default as ChevronLeft>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-right.js [app-client] (ecmascript) <export default as ChevronRight>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
const reviews = [
    {
        rating: 5,
        title: "The best booking system",
        body: "Great experience, easy to book. Paying for treatments is so convenient — no cash or cards needed!",
        reviewerName: "Lucy",
        location: "London, UK"
    },
    {
        rating: 5,
        title: "Easy to use & explore",
        body: "Fresha's premium make life so much easier! I also found a few good barbershops that I didn't know existed.",
        reviewerName: "Dan",
        location: "New York, USA"
    },
    {
        rating: 5,
        title: "Great for finding barbers",
        body: "I've been using Fresha for two years and it's by far the best booking platform I've used. Highly recommend it!",
        reviewerName: "Dale",
        location: "Sydney, Australia"
    },
    {
        rating: 5,
        title: "My go-to for self-care",
        body: "Fresha is my go-to app for haircuts and facials. I can easily find and book places near me — I love it!",
        reviewerName: "Cameron",
        location: "Edinburgh, UK"
    }
];
function ReviewsSection() {
    _s();
    const scrollRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const scroll = (direction)=>{
        if (scrollRef.current) {
            const scrollAmount = 400;
            scrollRef.current.scrollBy({
                left: direction === "left" ? -scrollAmount : scrollAmount,
                behavior: "smooth"
            });
        }
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PageSection"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "py-8 sm:py-12 md:py-16",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "mb-6 sm:mb-8",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                            className: "text-2xl sm:text-3xl md:text-4xl font-bold",
                            style: {
                                color: "var(--text-primary)"
                            },
                            children: "Reviews"
                        }, void 0, false, {
                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                            lineNumber: 66,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                        lineNumber: 65,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative",
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scroll("left"),
                                className: "absolute left-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-2 md:p-2.5 lg:p-3 transition-shadow hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "var(--shadow-sm)"
                                },
                                "aria-label": "Scroll left",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__["ChevronLeft"], {
                                    className: "w-4 h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                    lineNumber: 86,
                                    columnNumber: 15
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                lineNumber: 76,
                                columnNumber: 13
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                ref: scrollRef,
                                className: "flex gap-3 sm:gap-4 md:gap-6 overflow-x-auto scrollbar-hide scroll-smooth pb-4 items-stretch px-2 md:px-0",
                                style: {
                                    scrollbarWidth: "none",
                                    msOverflowStyle: "none",
                                    WebkitOverflowScrolling: "touch"
                                },
                                children: reviews.map((review, index)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex-shrink-0 w-[260px] sm:w-[280px] md:w-[320px] lg:w-[340px] flex flex-col p-5 sm:p-6 md:p-7 rounded-2xl",
                                        style: {
                                            backgroundColor: "#f5f5f5"
                                        },
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex gap-1 mb-3 sm:mb-4",
                                                children: [
                                                    ...Array(review.rating)
                                                ].map((_, i)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$star$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Star$3e$__["Star"], {
                                                        className: "w-4 h-4",
                                                        style: {
                                                            fill: "#facc15",
                                                            color: "#facc15"
                                                        }
                                                    }, i, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                        lineNumber: 113,
                                                        columnNumber: 23
                                                    }, this))
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                lineNumber: 111,
                                                columnNumber: 19
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                                className: "text-lg sm:text-xl font-bold mb-3 line-clamp-2",
                                                style: {
                                                    color: "#000000"
                                                },
                                                children: review.title
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                lineNumber: 124,
                                                columnNumber: 19
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                className: "text-sm sm:text-base mb-6 sm:mb-8 line-clamp-3",
                                                style: {
                                                    color: "#4a5568"
                                                },
                                                children: review.body
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                lineNumber: 131,
                                                columnNumber: 19
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex items-center gap-3 mt-auto",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "w-11 h-11 rounded-full flex items-center justify-center text-white text-base font-semibold flex-shrink-0",
                                                        style: {
                                                            backgroundColor: "#10b981"
                                                        },
                                                        children: review.reviewerName.charAt(0)
                                                    }, void 0, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                        lineNumber: 139,
                                                        columnNumber: 21
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                className: "text-base font-semibold",
                                                                style: {
                                                                    color: "#000000"
                                                                },
                                                                children: review.reviewerName
                                                            }, void 0, false, {
                                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                                lineNumber: 143,
                                                                columnNumber: 23
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                className: "text-sm",
                                                                style: {
                                                                    color: "#6b7280"
                                                                },
                                                                children: review.location
                                                            }, void 0, false, {
                                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                                lineNumber: 149,
                                                                columnNumber: 23
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                        lineNumber: 142,
                                                        columnNumber: 21
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                                lineNumber: 138,
                                                columnNumber: 19
                                            }, this)
                                        ]
                                    }, index, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                        lineNumber: 103,
                                        columnNumber: 17
                                    }, this))
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                lineNumber: 93,
                                columnNumber: 13
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scroll("right"),
                                className: "absolute right-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-2 md:p-2.5 lg:p-3 transition-shadow hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "var(--shadow-sm)"
                                },
                                "aria-label": "Scroll right",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                                    className: "w-4 h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                    lineNumber: 172,
                                    columnNumber: 15
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                                lineNumber: 162,
                                columnNumber: 13
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                        lineNumber: 74,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
                lineNumber: 64,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
            lineNumber: 63,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/ReviewsSection.tsx",
        lineNumber: 62,
        columnNumber: 5
    }, this);
}
_s(ReviewsSection, "rUl6RJdP9XfufN21BrtKqIOri0o=");
_c = ReviewsSection;
var _c;
__turbopack_context__.k.register(_c, "ReviewsSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CityDirectorySection",
    ()=>CityDirectorySection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-left.js [app-client] (ecmascript) <export default as ChevronLeft>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/lucide-react/dist/esm/icons/chevron-right.js [app-client] (ecmascript) <export default as ChevronRight>");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/Container.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/components/layout/PageSection.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
const serviceTypes = [
    "Hair Salons",
    "Nails",
    "Spas",
    "Beauty Salons",
    "Barbers",
    "Massage Partners",
    "Waxing Salons"
];
// Country to cities mapping
const countryCitiesMap = {
    Australia: [
        {
            name: "Sydney",
            services: serviceTypes
        },
        {
            name: "Melbourne",
            services: serviceTypes
        },
        {
            name: "Perth",
            services: serviceTypes
        },
        {
            name: "Brisbane",
            services: serviceTypes
        },
        {
            name: "Gold Coast",
            services: serviceTypes
        }
    ],
    Canada: [
        {
            name: "Toronto",
            services: serviceTypes
        },
        {
            name: "Vancouver",
            services: serviceTypes
        },
        {
            name: "Montreal",
            services: serviceTypes
        },
        {
            name: "Calgary",
            services: serviceTypes
        }
    ],
    France: [
        {
            name: "Paris",
            services: serviceTypes
        },
        {
            name: "Lyon",
            services: serviceTypes
        },
        {
            name: "Marseille",
            services: serviceTypes
        },
        {
            name: "Toulouse",
            services: serviceTypes
        }
    ],
    Germany: [
        {
            name: "Berlin",
            services: serviceTypes
        },
        {
            name: "Munich",
            services: serviceTypes
        },
        {
            name: "Hamburg",
            services: serviceTypes
        },
        {
            name: "Frankfurt",
            services: serviceTypes
        }
    ],
    Italy: [
        {
            name: "Rome",
            services: serviceTypes
        },
        {
            name: "Milan",
            services: serviceTypes
        },
        {
            name: "Naples",
            services: serviceTypes
        },
        {
            name: "Turin",
            services: serviceTypes
        }
    ],
    Netherlands: [
        {
            name: "Amsterdam",
            services: serviceTypes
        },
        {
            name: "Rotterdam",
            services: serviceTypes
        },
        {
            name: "The Hague",
            services: serviceTypes
        },
        {
            name: "Utrecht",
            services: serviceTypes
        }
    ],
    Belgium: [
        {
            name: "Brussels",
            services: serviceTypes
        },
        {
            name: "Antwerp",
            services: serviceTypes
        },
        {
            name: "Ghent",
            services: serviceTypes
        }
    ],
    Brazil: [
        {
            name: "São Paulo",
            services: serviceTypes
        },
        {
            name: "Rio de Janeiro",
            services: serviceTypes
        },
        {
            name: "Brasília",
            services: serviceTypes
        }
    ],
    Denmark: [
        {
            name: "Copenhagen",
            services: serviceTypes
        },
        {
            name: "Aarhus",
            services: serviceTypes
        },
        {
            name: "Odense",
            services: serviceTypes
        }
    ],
    Greece: [
        {
            name: "Athens",
            services: serviceTypes
        },
        {
            name: "Thessaloniki",
            services: serviceTypes
        },
        {
            name: "Patras",
            services: serviceTypes
        }
    ],
    Ireland: [
        {
            name: "Dublin",
            services: serviceTypes
        },
        {
            name: "Cork",
            services: serviceTypes
        },
        {
            name: "Galway",
            services: serviceTypes
        }
    ],
    Mexico: [
        {
            name: "Mexico City",
            services: serviceTypes
        },
        {
            name: "Guadalajara",
            services: serviceTypes
        },
        {
            name: "Monterrey",
            services: serviceTypes
        }
    ],
    Barbados: [
        {
            name: "Bridgetown",
            services: serviceTypes
        },
        {
            name: "Speightstown",
            services: serviceTypes
        }
    ]
};
const countries = Object.keys(countryCitiesMap);
function CityDirectorySection() {
    _s();
    // Default to Australia (as shown in screenshot)
    const [activeCountry, setActiveCountry] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])("Australia");
    // Refs for carousels
    const countryScrollRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const citiesScrollRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    // State for arrow visibility
    const [countryShowLeft, setCountryShowLeft] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [countryShowRight, setCountryShowRight] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    const [citiesShowLeft, setCitiesShowLeft] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [citiesShowRight, setCitiesShowRight] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    // Get cities for the active country
    const citiesData = countryCitiesMap[activeCountry] || [];
    // Check scroll position for country carousel
    const checkCountryScroll = ()=>{
        if (countryScrollRef.current) {
            const { scrollLeft, scrollWidth, clientWidth } = countryScrollRef.current;
            setCountryShowLeft(scrollLeft > 10);
            setCountryShowRight(scrollLeft < scrollWidth - clientWidth - 10);
        }
    };
    // Check scroll position for cities carousel
    const checkCitiesScroll = ()=>{
        if (citiesScrollRef.current) {
            const { scrollLeft, scrollWidth, clientWidth } = citiesScrollRef.current;
            setCitiesShowLeft(scrollLeft > 10);
            setCitiesShowRight(scrollLeft < scrollWidth - clientWidth - 10);
        }
    };
    // Scroll functions for country carousel
    const scrollCountry = (direction)=>{
        if (countryScrollRef.current) {
            const scrollAmount = 200;
            countryScrollRef.current.scrollBy({
                left: direction === "left" ? -scrollAmount : scrollAmount,
                behavior: "smooth"
            });
        }
    };
    // Scroll functions for cities carousel
    const scrollCities = (direction)=>{
        if (citiesScrollRef.current) {
            const scrollAmount = 400;
            citiesScrollRef.current.scrollBy({
                left: direction === "left" ? -scrollAmount : scrollAmount,
                behavior: "smooth"
            });
        }
    };
    // Set up scroll listeners
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "CityDirectorySection.useEffect": ()=>{
            const countryElement = countryScrollRef.current;
            const citiesElement = citiesScrollRef.current;
            if (countryElement) {
                checkCountryScroll();
                countryElement.addEventListener("scroll", checkCountryScroll);
                // Check on resize
                window.addEventListener("resize", checkCountryScroll);
            }
            if (citiesElement) {
                checkCitiesScroll();
                citiesElement.addEventListener("scroll", checkCitiesScroll);
                // Check on resize
                window.addEventListener("resize", checkCitiesScroll);
            }
            return ({
                "CityDirectorySection.useEffect": ()=>{
                    if (countryElement) {
                        countryElement.removeEventListener("scroll", checkCountryScroll);
                        window.removeEventListener("resize", checkCountryScroll);
                    }
                    if (citiesElement) {
                        citiesElement.removeEventListener("scroll", checkCitiesScroll);
                        window.removeEventListener("resize", checkCitiesScroll);
                    }
                }
            })["CityDirectorySection.useEffect"];
        }
    }["CityDirectorySection.useEffect"], [
        activeCountry
    ]); // Re-check when country changes
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$PageSection$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PageSection"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$components$2f$layout$2f$Container$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Container"], {
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "py-8 sm:py-12 md:py-16",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                        className: "text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold mb-4 sm:mb-6 md:mb-8",
                        style: {
                            color: "var(--text-primary)"
                        },
                        children: "Browse by City"
                    }, void 0, false, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                        lineNumber: 191,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative mb-4 sm:mb-6 md:mb-8",
                        children: [
                            countryShowLeft && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scrollCountry("left"),
                                className: "absolute left-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-1.5 sm:p-2 bg-white border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "var(--shadow-sm)"
                                },
                                "aria-label": "Scroll countries left",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__["ChevronLeft"], {
                                    className: "w-3 h-3 sm:w-4 sm:h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                    lineNumber: 212,
                                    columnNumber: 17
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 202,
                                columnNumber: 15
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                ref: countryScrollRef,
                                className: "flex gap-2 overflow-x-auto scrollbar-hide scroll-smooth pb-2 px-1",
                                style: {
                                    scrollbarWidth: "none",
                                    msOverflowStyle: "none",
                                    WebkitOverflowScrolling: "touch"
                                },
                                children: countries.map((country)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        onClick: ()=>setActiveCountry(country),
                                        className: "px-3 py-1.5 sm:px-4 sm:py-2 rounded-full text-xs sm:text-sm font-semibold transition-colors whitespace-nowrap flex-shrink-0",
                                        style: {
                                            backgroundColor: activeCountry === country ? "var(--text-primary)" : "transparent",
                                            color: activeCountry === country ? "var(--surface)" : "var(--text-primary)"
                                        },
                                        children: country
                                    }, country, false, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                        lineNumber: 230,
                                        columnNumber: 17
                                    }, this))
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 220,
                                columnNumber: 13
                            }, this),
                            countryShowRight && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scrollCountry("right"),
                                className: "absolute right-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-1.5 sm:p-2 bg-white border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "var(--shadow-sm)"
                                },
                                "aria-label": "Scroll countries right",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                                    className: "w-3 h-3 sm:w-4 sm:h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                    lineNumber: 262,
                                    columnNumber: 17
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 252,
                                columnNumber: 15
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                        lineNumber: 199,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative",
                        children: [
                            citiesShowLeft && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scrollCities("left"),
                                className: "absolute left-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-2 md:p-3 bg-white border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "0 1px 2px 0 rgb(0 0 0 / 0.05)"
                                },
                                "aria-label": "Scroll cities left",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$left$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronLeft$3e$__["ChevronLeft"], {
                                    className: "w-4 h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                    lineNumber: 284,
                                    columnNumber: 17
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 274,
                                columnNumber: 15
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                ref: citiesScrollRef,
                                className: "flex gap-6 md:gap-8 overflow-x-auto scrollbar-hide scroll-smooth pb-4 items-start",
                                style: {
                                    scrollbarWidth: "none",
                                    msOverflowStyle: "none"
                                },
                                children: citiesData.map((city)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex-shrink-0 w-[200px] sm:w-[240px] md:w-[260px] lg:w-[300px]",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                                href: `/city/${city.name.toLowerCase().replace(/\s+/g, "-")}`,
                                                className: "text-base sm:text-lg md:text-xl font-semibold block mb-2 sm:mb-3 hover:underline",
                                                style: {
                                                    color: "var(--text-primary)"
                                                },
                                                children: city.name
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                                lineNumber: 302,
                                                columnNumber: 19
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("ul", {
                                                className: "space-y-1",
                                                children: city.services.map((service)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("li", {
                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                                            href: `/city/${city.name.toLowerCase().replace(/\s+/g, "-")}/${service.toLowerCase().replace(/\s+/g, "-")}`,
                                                            className: "text-xs sm:text-sm md:text-base block hover:underline",
                                                            style: {
                                                                color: "var(--text-secondary)"
                                                            },
                                                            children: [
                                                                service,
                                                                " in ",
                                                                city.name
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                                            lineNumber: 314,
                                                            columnNumber: 25
                                                        }, this)
                                                    }, service, false, {
                                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                                        lineNumber: 313,
                                                        columnNumber: 23
                                                    }, this))
                                            }, void 0, false, {
                                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                                lineNumber: 311,
                                                columnNumber: 19
                                            }, this)
                                        ]
                                    }, city.name, true, {
                                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                        lineNumber: 298,
                                        columnNumber: 17
                                    }, this))
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 292,
                                columnNumber: 13
                            }, this),
                            citiesShowRight && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                onClick: ()=>scrollCities("right"),
                                className: "absolute right-0 top-1/2 -translate-y-1/2 z-10 rounded-full p-2 md:p-3 bg-white border border-gray-200 shadow-sm hover:shadow-md transition-all duration-200 hidden md:block",
                                style: {
                                    backgroundColor: "var(--surface)",
                                    border: "1px solid var(--color-gray-300)",
                                    boxShadow: "0 1px 2px 0 rgb(0 0 0 / 0.05)"
                                },
                                "aria-label": "Scroll cities right",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                                    className: "w-4 h-4 md:w-5 md:h-5",
                                    style: {
                                        color: "var(--text-primary)"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                    lineNumber: 344,
                                    columnNumber: 17
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                                lineNumber: 334,
                                columnNumber: 15
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                        lineNumber: 271,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
                lineNumber: 190,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
            lineNumber: 189,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/sigitechnologies.cloud/src/features/home/components/CityDirectorySection.tsx",
        lineNumber: 188,
        columnNumber: 5
    }, this);
}
_s(CityDirectorySection, "jzJbNDARpssXCOaGfRcKsVhQi/Y=");
_c = CityDirectorySection;
var _c;
__turbopack_context__.k.register(_c, "CityDirectorySection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=sigitechnologies_cloud_src_f04863fe._.js.map