/// <reference types="@types/google.maps" />

declare global {
  namespace google {
    namespace maps {
      class Map {
        constructor(element: HTMLElement, options?: any);
        fitBounds(bounds: LatLngBounds): void;
        setCenter(latLng: LatLng | { lat: number; lng: number }): void;
      }
      class Marker {
        constructor(options?: any);
        setMap(map: Map | null): void;
        addListener(eventName: string, handler: () => void): void;
        getPosition(): LatLng | null;
      }
      class LatLngBounds {
        constructor();
        extend(latLng: LatLng | { lat: number; lng: number }): void;
      }
      class LatLng {
        constructor(lat: number, lng: number);
        lat(): number;
        lng(): number;
      }
      namespace places {
        class AutocompleteService {
          getPlacePredictions(
            request: any,
            callback: (predictions: AutocompletePrediction[], status: any) => void
          ): void;
        }
        interface AutocompletePrediction {
          place_id: string;
          description: string;
          structured_formatting?: {
            main_text: string;
            secondary_text: string;
          };
        }
        enum PlacesServiceStatus {
          OK = "OK",
        }
      }
      class Geocoder {
        geocode(request: any, callback: (results: any[], status: any) => void): void;
      }
      namespace ControlPosition {
        const BOTTOM_RIGHT: any;
      }
      namespace event {
        function trigger(instance: any, eventName: string): void;
      }
    }
  }
  interface Window {
    google: typeof google;
  }
}

export {};
