import { z } from "zod";

export const AppointmentServiceSchema = z.object({
  serviceId: z.number(),
  duration: z.number(),
  total: z.number(),
  serviceDiscount: z.number().optional(),
});

export const AppointmentSchema = z.object({
  salonDetailId: z.string(),
  startTime: z.string(),
  endTime: z.string(),
  duration: z.number(),
  subTotal: z.number(),
  discount: z.number(),
  note: z.string().optional(),
  total: z.number(),
  tip: z.number().optional(),
  on: z.string(), // Date in YYYY-MM-DD format
  cancellationPolicyVersion: z.number().optional(),
  reschedulePolicyVersion: z.number().optional(),
  upFrontPolicyVersion: z.number().optional(),
  noshowPolicyVersion: z.number().optional(),
  actualCapturedAmount: z.number().optional(),
  initialPayment: z.number().optional(),
  upFrontPaymentPercentage: z.number().optional(),
});

export const BookAppointmentRequestSchema = z.object({
  platform: z.string(),
  customerEmail: z.string().email(),
  employeeId: z.string().optional(),
  paymentMethod: z.enum(["card", "cash"]),
  onlinePayment: z.boolean(),
  stripeCardId: z.string().optional(),
  stripeCustomerId: z.string().optional(),
  initialPaymentIntend: z.string().optional(),
  appointment: AppointmentSchema,
  services: z.array(AppointmentServiceSchema),
});

export type AppointmentService = z.infer<typeof AppointmentServiceSchema>;
export type Appointment = z.infer<typeof AppointmentSchema>;
export type BookAppointmentRequest = z.infer<typeof BookAppointmentRequestSchema>;





