/**
 * Zod Schemas for Appointments API
 */

import { z } from "zod";

export const AppointmentAddressDBSchema = z.object({
  streetAddress: z.string(),
  city: z.string(),
  district: z.string().optional(),
  province: z.string().optional(),
  country: z.string().optional(),
});

export const AppointmentSalonDetailSchema = z.object({
  id: z.number().optional(),
  salonName: z.string(),
  coverImage: z.string().nullable(),
  addressDB: AppointmentAddressDBSchema.optional(),
});

export const AppointmentSchema = z.object({
  id: z.number(),
  status: z.string(), // "book", "complete", etc.
  startTime: z.string(), // "14:01:00"
  endTime: z.string(), // "14:36:00"
  on: z.string(), // "2025-10-15"
  total: z.string(),
  subTotal: z.string(),
  noshowCharges: z.string(),
  cancellationCharges: z.string(),
  serviceCount: z.number(),
  salonDetail: AppointmentSalonDetailSchema,
});

export const GetAppointmentsResponseSchema = z.object({
  appointments: z.array(AppointmentSchema),
  currencyUnit: z.string(),
});

export type Appointment = z.infer<typeof AppointmentSchema>;
export type GetAppointmentsResponse = z.infer<
  typeof GetAppointmentsResponseSchema
>;
