export function formatTime(
  date: Date | string,
  format: "12h" | "24h" = "12h"
): string {
  const d = typeof date === "string" ? new Date(date) : date;

  if (format === "24h") {
    return d.toLocaleTimeString("en-GB", {
      hour: "2-digit",
      minute: "2-digit",
      hour12: false,
    });
  }

  return d.toLocaleTimeString("en-GB", {
    hour: "2-digit",
    minute: "2-digit",
    hour12: true,
  });
}
