/**
 * Client-side Authentication Helpers
 * Tokens are read from localStorage
 * Use this in Client Components
 */

import { getAccessToken } from "@/lib/auth";

/**
 * Client-side token getter (for use in client components)
 * This reads from localStorage using the existing auth helper
 */
export function getClientToken(): string | null {
  if (typeof window === "undefined") {
    return null;
  }
  // Use existing auth helper for consistency
  return getAccessToken();
}




