/**
 * React Query hook for searching venues
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { searchVenuesClient } from "../api/searchVenues";
import { Venue } from "@/lib/schemas/venue";
import { SearchVenuesParams } from "../api/searchVenues";

export function useSearchVenues(
  params: SearchVenuesParams,
  options?: Omit<
    UseQueryOptions<
      { venues: Venue[]; total: number },
      Error,
      { venues: Venue[]; total: number },
      (string | number)[]
    >,
    "queryKey" | "queryFn" | "enabled"
  >
) {
  return useQuery({
    queryKey: [
      "search-venues",
      params.query || "",
      params.location || "",
      params.category || "",
      params.minRating || 0,
      params.page || 1,
      params.sortBy || "relevance",
    ],
    queryFn: () => searchVenuesClient(params),
    enabled: !!(params.query || params.location),
    ...options,
  });
}




