/**
 * Get Service Types API - Client Side Only
 * Fetches all available service types
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import { z } from "zod";

const ServiceTypeSchema = z.object({
  id: z.number(),
  typeName: z.string(),
  image: z.string(),
  serviceOrder: z.number(),
  status: z.boolean(),
  createdAt: z.string(),
});

export type ServiceType = z.infer<typeof ServiceTypeSchema>;

/**
 * Client-side: Get service types
 * Note: clientFetcher already extracts data.data, so we receive the array directly
 */
export async function getServiceTypesClient(): Promise<ServiceType[]> {
  const data = await clientFetcher<unknown>("/customer/service-types", {
    requireAuth: false,
    method: "GET",
  });

  // clientFetcher already extracts data.data, so we get the array directly
  const parsed = z.array(ServiceTypeSchema).parse(data);
  return parsed;
}

