/**
 * React Query hook for like/dislike salon
 */

import { useMutation, UseMutationOptions, useQueryClient } from "@tanstack/react-query";
import { likeDislikeSalonClient } from "../api/likeDislikeSalon-client";
import {
  LikeDislikeSalonRequest,
  LikeDislikeSalonResponse,
} from "@/lib/schemas/favorites";

export function useLikeDislikeSalon(
  options?: UseMutationOptions<
    LikeDislikeSalonResponse,
    Error,
    LikeDislikeSalonRequest
  >
) {
  const queryClient = useQueryClient();

  const originalOnSuccess = options?.onSuccess;

  return useMutation({
    mutationFn: likeDislikeSalonClient,
    ...options,
    onSuccess: (data, variables, context, mutation) => {
      // Invalidate favorites queries to refetch updated list
      queryClient.invalidateQueries({ queryKey: ["favorites"] });
      
      // Call the original onSuccess if provided
      if (originalOnSuccess) {
        originalOnSuccess(data, variables, context, mutation);
      }
    },
  });
}

