"use client";

import { SalonDetail } from "@/lib/schemas/salonDetail";

interface SalonFixedBookBarProps {
  salon: SalonDetail;
}

export function SalonFixedBookBar({ salon }: SalonFixedBookBarProps) {
  const totalServices =
    salon.categories?.reduce(
      (sum, cat) => sum + (cat.services?.length || 0),
      0
    ) || 0;

  const handleBookNow = () => {
    // Scroll to booking card or trigger booking
    const bookingCard = document.querySelector('[data-booking-card]');
    if (bookingCard) {
      bookingCard.scrollIntoView({ behavior: "smooth", block: "start" });
    }
  };

  return (
    <div className="block lg:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-lg z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between py-3 md:py-4">
          <div className="flex items-center gap-2 md:gap-4 flex-1 min-w-0">
            <h3 className="text-sm md:text-base font-semibold text-gray-900 truncate">
              {salon.salonName || "Salon"}
            </h3>
            <span className="text-xs md:text-sm text-gray-600 whitespace-nowrap">
              {totalServices} service{totalServices !== 1 ? "s" : ""} available
            </span>
          </div>
          <button
            onClick={handleBookNow}
            className="px-4 md:px-6 py-2 md:py-3 bg-black text-white rounded-lg hover:bg-gray-800 transition-colors font-medium text-xs md:text-sm whitespace-nowrap flex-shrink-0"
          >
            Book now
          </button>
        </div>
      </div>
    </div>
  );
}

