/**
 * Upfront Payment Info API - Client Side
 * Gets payment information for upfront payment
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  UpfrontPaymentInfoRequestSchema,
  UpfrontPaymentInfoResponseSchema,
  type UpfrontPaymentInfoRequest,
  type UpfrontPaymentInfoResponse,
} from "@/lib/schemas/stripe";

/**
 * Client-side: Get upfront payment info
 * Use in Client Components, React Query hooks
 */
export async function upfrontPaymentInfoClient(
  request: UpfrontPaymentInfoRequest
): Promise<UpfrontPaymentInfoResponse> {
  // Validate request
  const validatedRequest = UpfrontPaymentInfoRequestSchema.parse(request);

  const data = await clientFetcher<unknown>(
    "/customer/upfront-payment-info",
    {
      requireAuth: true,
      method: "POST",
      body: JSON.stringify(validatedRequest),
    }
  );

  return UpfrontPaymentInfoResponseSchema.parse(data);
}

