/**
 * Client-side: Like/Dislike Salon
 * Use in Client Components, React Query hooks
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  LikeDislikeSalonRequestSchema,
  LikeDislikeSalonResponseSchema,
  type LikeDislikeSalonRequest,
  type LikeDislikeSalonResponse,
} from "@/lib/schemas/favorites";

export async function likeDislikeSalonClient(
  request: LikeDislikeSalonRequest
): Promise<LikeDislikeSalonResponse> {
  // Validate request
  const validatedRequest = LikeDislikeSalonRequestSchema.parse(request);
  
  const salonId = typeof validatedRequest.salonId === "string" 
    ? validatedRequest.salonId 
    : validatedRequest.salonId.toString();

  const endpoint = `/customer/like-dislike/${salonId}`;

  const data = await clientFetcher<unknown>(endpoint, {
    requireAuth: true, // Requires authentication
    method: "PATCH",
  });

  // Parse with better error handling
  try {
    return LikeDislikeSalonResponseSchema.parse(data);
  } catch (error) {
    // Log the raw data for debugging
    console.error("Zod validation failed. Raw data:", JSON.stringify(data, null, 2));
    throw error;
  }
}

