/**
 * Get Salon Detail API - Client Side
 * Fetches detailed information about a salon
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  SalonDetailResponseSchema,
  type SalonDetailResponse,
} from "@/lib/schemas/salonDetail";

/**
 * Client-side: Get salon detail
 * Use in Client Components, React Query hooks
 */
export async function getSalonDetailClient(
  salonId: string | number
): Promise<SalonDetailResponse> {
  const data = await clientFetcher<unknown>(
    `/customer/salon-detail/${salonId}`,
    {
      requireAuth: false,
      method: "GET",
    }
  );

  return SalonDetailResponseSchema.parse(data);
}
