/**
 * React Query hook for appointments
 */

import { useQuery } from "@tanstack/react-query";
import { getAppointmentsClient } from "../api/getAppointments-client";
import type { GetAppointmentsResponse } from "@/lib/schemas/appointment";

export function useAppointments() {
  return useQuery<GetAppointmentsResponse>({
    queryKey: ["appointments"],
    queryFn: async () => {
      return await getAppointmentsClient();
    },
    staleTime: 2 * 60 * 1000, // 2 minutes
    retry: 1,
  });
}



