"use client";

import { Home, Briefcase, Plus } from "lucide-react";
import { Button } from "@/components/ui/button";

interface AddressCardProps {
  icon: React.ComponentType<{ className?: string }>;
  label: string;
  placeholder: string;
}

function AddressCard({ icon: Icon, label, placeholder }: AddressCardProps) {
  return (
    <div className="bg-white rounded-xl border border-gray-200 p-4 md:p-6 flex items-start gap-3 md:gap-4">
      <div className="w-10 h-10 md:w-12 md:h-12 rounded-lg bg-gray-100 flex items-center justify-center flex-shrink-0">
        <Icon className="w-5 h-5 md:w-6 md:h-6 text-gray-600" />
      </div>
      <div className="flex-1">
        <h3 className="text-sm md:text-base font-semibold text-gray-900 mb-1">
          {label}
        </h3>
        <p className="text-xs md:text-sm text-gray-500">{placeholder}</p>
      </div>
    </div>
  );
}

export function AddressesSection() {
  return (
    <div className="mt-6 lg:mt-0">
      <h2 className="text-base md:text-lg font-bold text-gray-900 mb-4">My addresses</h2>
      <div className="space-y-3 md:space-y-4 mb-4">
        <AddressCard
          icon={Home}
          label="Home"
          placeholder="Add a home address"
        />
        <AddressCard
          icon={Briefcase}
          label="Work"
          placeholder="Add a work address"
        />
      </div>
      <Button variant="outline" className="w-full text-sm md:text-base">
        <Plus className="w-4 h-4 mr-2" />
        Add
      </Button>
    </div>
  );
}

