/**
 * Client-side: Get appointments
 * Use in Client Components, React Query hooks
 */

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  GetAppointmentsResponseSchema,
  type GetAppointmentsResponse,
} from "@/lib/schemas/appointment";

export async function getAppointmentsClient(): Promise<GetAppointmentsResponse> {
  const data = await clientFetcher<unknown>("/customer/appointments", {
    requireAuth: true, // Requires authentication
    method: "GET",
  });

  // Parse with better error handling
  try {
    return GetAppointmentsResponseSchema.parse(data);
  } catch (error) {
    // Log the raw data for debugging
    console.error("Zod validation failed. Raw data:", JSON.stringify(data, null, 2));
    throw error;
  }
}



