/**
 * Get Account Deletion Reasons API - Client Side
 * Fetches available reasons for account deletion
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  GetAccountDeletionReasonsResponseSchema,
  type GetAccountDeletionReasonsResponse,
} from "@/lib/schemas/accountDeletion";

/**
 * Client-side: Get account deletion reasons
 * Use in Client Components, React Query hooks
 */
export async function getAccountDeletionReasonsClient(): Promise<GetAccountDeletionReasonsResponse> {
  const data = await clientFetcher<unknown>(
    "/customer/account-deletion-reasons",
    {
      requireAuth: true,
      method: "GET",
    }
  );

  return GetAccountDeletionReasonsResponseSchema.parse(data);
}

