/**
 * React Query hook for fetching home page venues
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { getHomeVenuesClient } from "../api/getHomeVenues-client";
import {
  GetHomeVenuesRequest,
  GetHomeVenuesResponse,
} from "@/lib/schemas/home";

export function useHomeVenues(
  request: GetHomeVenuesRequest,
  options?: Omit<
    UseQueryOptions<
      GetHomeVenuesResponse,
      Error,
      GetHomeVenuesResponse,
      string[]
    >,
    "queryKey" | "queryFn"
  >
) {
  return useQuery({
    queryKey: [
      "home-venues",
      request.targetLat.toString(),
      request.targetLng.toString(),
      request.rangeInKm.toString(),
      request.serviceType || "all",
    ],
    queryFn: () => getHomeVenuesClient(request),
    enabled: !!request.targetLat && !!request.targetLng && request.rangeInKm > 0,
    ...options,
  });
}

