"use client";

import { HorizontalCarousel } from "@/components/carousel/HorizontalCarousel";
import { VenueCard } from "./VenueCard";
import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";
import { useHomepageData } from "../hooks/useHomepageData";

export function TrendingSection() {
  const { trendingVenues } = useHomepageData();

  return (
    <PageSection>
      <Container>
        <HorizontalCarousel title="Trending">
          {trendingVenues.map((venue) => (
            <VenueCard key={venue.id} venue={venue} />
          ))}
        </HorizontalCarousel>
      </Container>
    </PageSection>
  );
}
