import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";

export function TopStatsSection() {
  return (
    <PageSection>
      <Container>
        <div className="py-8 sm:py-12 md:py-16 lg:py-20 text-center px-2 sm:px-4">
          <h2
            className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-3 sm:mb-4"
            style={{ color: "var(--text-primary)" }}
          >
            The top-rated destination for selfcare
          </h2>

          <p
            className="text-sm sm:text-base md:text-lg mb-8 sm:mb-12 md:mb-16 lg:mb-20 max-w-2xl mx-auto px-2 sm:px-4"
            style={{ color: "var(--text-secondary)" }}
          >
            One solution, one software. Trusted by the best in the selfcare
            industry.
          </p>

          <div className="mb-8 sm:mb-12 md:mb-16 lg:mb-20">
            <div
              className="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-bold mb-2 sm:mb-3 md:mb-4"
              style={{ color: "var(--text-primary)" }}
            >
              1 billion+
            </div>
            <p
              className="text-sm sm:text-base md:text-lg px-2 sm:px-4"
              style={{ color: "var(--text-secondary)" }}
            >
              appointments booked on Fresha
            </p>
          </div>

          <div className="grid grid-cols-1 sm:grid-cols-3 gap-6 sm:gap-8 md:gap-12 max-w-4xl mx-auto">
            <div>
              <div
                className="text-3xl sm:text-4xl md:text-5xl font-bold mb-2"
                style={{ color: "var(--text-primary)" }}
              >
                130,000+
              </div>
              <p
                className="text-xs sm:text-sm md:text-base"
                style={{ color: "var(--text-secondary)" }}
              >
                partner businesses
              </p>
            </div>
            <div>
              <div
                className="text-3xl sm:text-4xl md:text-5xl font-bold mb-2"
                style={{ color: "var(--text-primary)" }}
              >
                120+
              </div>
              <p
                className="text-xs sm:text-sm md:text-base"
                style={{ color: "var(--text-secondary)" }}
              >
                countries
              </p>
              <p
                className="text-xs mt-1"
                style={{ color: "var(--text-muted)" }}
              >
                using Fresha
              </p>
            </div>
            <div>
              <div
                className="text-3xl sm:text-4xl md:text-5xl font-bold mb-2"
                style={{ color: "var(--text-primary)" }}
              >
                450,000+
              </div>
              <p
                className="text-xs sm:text-sm md:text-base"
                style={{ color: "var(--text-secondary)" }}
              >
                stylists and professionals
              </p>
            </div>
          </div>
        </div>
      </Container>
    </PageSection>
  );
}
