import Link from "next/link";
import { Star } from "lucide-react";
import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { routes } from "@/config/routes";

export function BusinessPromoSection() {
  return (
    <PageSection
      style={{
        background:
          "linear-gradient(to right, rgba(220, 252, 231, 0.4), rgba(255, 255, 255, 1) 50%)",
      }}
    >
      <Container>
        <div className="flex flex-col md:grid md:grid-cols-2 gap-6 sm:gap-8 md:gap-12 items-center py-8 sm:py-12 md:py-20">
          {/* Left Column: Text */}
          <div className="w-full md:w-auto text-center md:text-left">
            {/* Header - Extra-large, bold, charcoal */}
            <h2
              className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold mb-3 sm:mb-4 md:mb-6"
              style={{ color: "var(--text-primary)" }}
            >
              Fresha for business
            </h2>

            {/* Body text - Regular grey */}
            <p
              className="text-sm sm:text-base md:text-lg mb-4 sm:mb-6 md:mb-8 max-w-md mx-auto md:mx-0 font-normal"
              style={{ color: "var(--color-gray-600)" }}
            >
              Supercharge your business with the world's top booking platform
              for salons and spas. Independently voted no. 1 by industry
              professionals.
            </p>

            {/* CTA Button - Black background, white text, rounded-pill */}
            <Link href={routes.business}>
              <button
                className="mb-6 sm:mb-8 px-4 py-2 sm:px-6 sm:py-3 rounded-full text-sm sm:text-base font-medium transition-colors"
                style={{
                  backgroundColor: "var(--text-primary)",
                  color: "var(--surface)",
                }}
              >
                Find out more
                <span className="ml-2">→</span>
              </button>
            </Link>

            {/* Small Ratings Card - White, soft shadow, golden stars, charcoal text, very small spacing */}
            <div
              className="inline-block p-4"
              style={{
                backgroundColor: "var(--surface)",
                borderRadius: "var(--card-border-radius)",
                boxShadow: "var(--shadow-sm)",
              }}
            >
              <div className="flex items-center gap-2 mb-1">
                <span
                  className="text-lg font-bold"
                  style={{ color: "var(--text-primary)" }}
                >
                  Excellent
                </span>
                <span
                  className="text-base font-semibold"
                  style={{ color: "var(--text-primary)" }}
                >
                  5/5
                </span>
              </div>
              <div className="flex gap-0.5 mb-1">
                {[...Array(5)].map((_, i) => (
                  <Star
                    key={i}
                    className="w-3.5 h-3.5"
                    style={{ fill: "#facc15", color: "#facc15" }}
                  />
                ))}
              </div>
              <p
                className="text-xs font-normal"
                style={{ color: "var(--text-primary)" }}
              >
                Over 100,000 reviews on Capterra
              </p>
            </div>
          </div>

          {/* Right Column: Visuals - White cards with stronger shadows */}
          <div className="relative w-full md:w-auto">
            {/* Desktop Calendar Card - White, stronger shadow, card radius */}
            <div
              className="p-3 sm:p-4"
              style={{
                backgroundColor: "var(--surface)",
                borderRadius: "var(--card-border-radius)",
                boxShadow: "var(--shadow-lg)",
              }}
            >
              <div className="bg-gray-50 rounded-lg overflow-hidden">
                {/* Calendar Header */}
                <div className="bg-gray-100 p-4 border-b">
                  <div className="flex items-center justify-between mb-4">
                    <h3 className="font-bold text-lg">Booking Schedule</h3>
                    <div className="flex gap-2">
                      <div className="w-8 h-8 bg-gray-300 rounded"></div>
                      <div className="w-8 h-8 bg-gray-300 rounded"></div>
                    </div>
                  </div>
                  <div className="grid grid-cols-7 gap-2 text-xs text-gray-600">
                    {["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"].map(
                      (day) => (
                        <div key={day} className="text-center font-semibold">
                          {day}
                        </div>
                      )
                    )}
                  </div>
                </div>

                {/* Calendar Grid */}
                <div className="p-4">
                  <div className="grid grid-cols-7 gap-2">
                    {Array.from({ length: 35 }).map((_, i) => (
                      <div
                        key={i}
                        className="aspect-square bg-white border border-gray-200 rounded p-1"
                      >
                        {i % 7 === 3 && (
                          <div className="w-full h-full bg-pink-200 rounded flex items-center justify-center text-xs font-semibold">
                            10:00
                          </div>
                        )}
                        {i % 7 === 5 && (
                          <div className="w-full h-full bg-purple-200 rounded flex items-center justify-center text-xs font-semibold">
                            14:30
                          </div>
                        )}
                      </div>
                    ))}
                  </div>
                </div>
              </div>
            </div>

            {/* Phone Card - Overlaps calendar, white, stronger shadow, card radius - Hidden on mobile */}
            <div
              className="hidden md:block absolute -bottom-6 md:-bottom-8 -right-4 md:-right-8 w-32 md:w-40 lg:w-48 h-[200px] md:h-[280px] lg:h-[380px] bg-gray-900 rounded-[1.5rem] md:rounded-[2rem] p-1 md:p-1.5 lg:p-2 z-10"
              style={{
                boxShadow: "var(--shadow-lg)",
              }}
            >
              <div className="w-full h-full bg-white rounded-[1.75rem] overflow-hidden">
                <div className="h-full flex flex-col">
                  <div className="bg-gradient-to-r from-pink-100 to-purple-100 p-4">
                    <div className="w-full h-32 bg-gray-200 rounded-lg mb-2"></div>
                    <h4 className="font-bold text-sm mb-1">Salon Name</h4>
                    <div className="flex items-center gap-1 mb-1">
                      <Star className="w-3 h-3 fill-yellow-400 text-yellow-400" />
                      <span className="text-xs font-semibold">4.9</span>
                      <span className="text-xs text-gray-500">
                        (128 reviews)
                      </span>
                    </div>
                    <p className="text-xs text-gray-600">Hair Salon • London</p>
                  </div>
                  <div className="flex-1 p-4 space-y-2">
                    <div className="bg-gray-50 rounded-lg p-2">
                      <p className="text-xs text-gray-500">Service</p>
                      <p className="text-xs font-semibold">Haircut</p>
                    </div>
                    <div className="bg-gray-50 rounded-lg p-2">
                      <p className="text-xs text-gray-500">Price</p>
                      <p className="text-xs font-semibold">£45</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </Container>
    </PageSection>
  );
}
