import Image from "next/image";
import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";
import { Card } from "@/components/ui/card";

export function AppDownloadSection() {
  return (
    <PageSection className="py-8 sm:py-12 md:py-6">
      <Container>
        <div className="flex flex-col lg:grid lg:grid-cols-[1fr_auto] gap-8 sm:gap-10 md:gap-12 lg:gap-16 items-center">
          {/* Left Column: Text + QR */}
          <div className="w-full lg:w-auto text-center lg:text-left">
            {/* Available on */}
            <div className="flex items-center justify-center lg:justify-start gap-3 mb-4 sm:mb-6">
              <span
                className="text-xs sm:text-sm"
                style={{ color: "var(--text-muted)" }}
              >
                Available on
              </span>
              <div className="flex items-center gap-2">
                {/* Apple Logo */}
                <div className="w-5 h-5 sm:w-6 sm:h-6 bg-gray-900 rounded flex items-center justify-center">
                  <span className="text-white text-xs font-bold">⌘</span>
                </div>
                {/* Google Play Logo */}
                <div className="w-5 h-5 sm:w-6 sm:h-6 bg-gray-900 rounded flex items-center justify-center">
                  <span className="text-white text-xs font-bold">G</span>
                </div>
              </div>
            </div>

            {/* Main Heading */}
            <h2
              className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-3 sm:mb-4 md:mb-6"
              style={{ color: "var(--text-primary)" }}
            >
              Download the Fresha app
            </h2>

            {/* Description */}
            <p
              className="text-sm sm:text-base md:text-lg mb-6 sm:mb-8 max-w-md mx-auto lg:mx-0"
              style={{ color: "var(--text-secondary)" }}
            >
              Book unforgettable beauty and wellness experiences with the Fresha
              mobile app
            </p>

            {/* QR Code Card */}
            <Card className="inline-block p-4 sm:p-6 mb-4 sm:mb-6">
              <div className="w-32 h-32 sm:w-40 sm:h-40 md:w-44 md:h-44 lg:w-48 lg:h-48 bg-gray-100 rounded-lg flex items-center justify-center mb-3">
                <div className="w-28 h-28 sm:w-36 sm:h-36 md:w-40 md:h-40 lg:w-40 lg:h-40 bg-white border-2 border-gray-300 rounded grid grid-cols-8 grid-rows-8 gap-0.5 p-2">
                  {/* Simple QR code pattern */}
                  {Array.from({ length: 64 }).map((_, i) => (
                    <div
                      key={i}
                      className={`${
                        Math.random() > 0.5 ? "bg-gray-900" : "bg-white"
                      }`}
                    />
                  ))}
                </div>
              </div>
            </Card>

            {/* App Store Buttons */}
            <div className="flex flex-col sm:flex-row gap-3 justify-center lg:justify-start mt-4 sm:mt-6">
              {/* Google Play Button */}
              <a
                href="#"
                className="inline-flex items-center gap-3 px-4 py-3 bg-black border border-white/20 text-white rounded-lg hover:bg-gray-900 transition-colors"
              >
                {/* Google Play Icon */}
                <div className="flex-shrink-0">
                  <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M3 20.5V3.5C3 2.91 3.34 2.39 3.84 2.15L13.69 12L3.84 21.85C3.34 21.6 3 21.09 3 20.5ZM16.81 15.12L6.05 21.34L14.54 12.85L16.81 15.12ZM20.16 10.81C20.5 11.08 20.75 11.5 20.75 12C20.75 12.5 20.53 12.9 20.18 13.18L17.89 14.5L15.39 12L17.89 9.5L20.16 10.81ZM6.05 2.66L16.81 8.88L14.54 11.15L6.05 2.66Z"
                      fill="white"
                    />
                  </svg>
                </div>
                <div className="flex flex-col items-start">
                  <span className="text-[10px] uppercase tracking-wide leading-tight">
                    GET IT ON
                  </span>
                  <span className="text-base font-semibold leading-tight">
                    Google Play
                  </span>
                </div>
              </a>
            </div>
          </div>

          {/* Right Column: Two Phone Mockups - Hidden on mobile, shown on large screens */}
          <div className="relative hidden lg:block">
            <div className="flex gap-4 xl:gap-6 justify-center items-center">
              {/* Video Phone (Left, Smaller) */}
              <div className="relative">
                <div className="w-56 xl:w-64 h-[500px] xl:h-[560px] border-2 border-black rounded-[2.5rem] p-1.5">
                  <div className="w-full h-full bg-black rounded-[2rem] overflow-hidden relative">
                    {/* Video Player */}
                    <video
                      autoPlay
                      loop
                      muted
                      playsInline
                      className="w-full h-full object-cover"
                      poster="/images/demo-mobile.webp"
                    >
                      <source
                        src="/images/demo-video-mobile.mp4"
                        type="video/mp4"
                      />
                    </video>
                  </div>
                </div>
              </div>
              {/* Image Phone (Right, Larger) */}
              <div className="relative z-10">
                <div className="w-64 xl:w-72 h-[580px] xl:h-[650px] border-2 border-black rounded-[3rem] p-1.5">
                  <div className="w-full h-full bg-black rounded-[2.5rem] overflow-hidden relative">
                    {/* Image */}
                    <Image
                      src="/images/demo-mobile.webp"
                      alt="Fresha mobile app demo - map view"
                      fill
                      className="object-cover"
                      priority
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>

          {/* Mobile/Tablet View: Show Both Video and Image */}
          <div className="relative lg:hidden w-full mt-6">
            <div className="flex flex-row gap-4 sm:gap-6 md:gap-8 justify-center items-center">
              {/* Video (Smaller) */}
              <div className="relative w-full max-w-[240px] sm:max-w-[200px] md:max-w-[240px]">
                <div className="w-full aspect-[9/16] border-2 border-black rounded-[2rem] p-1.5 shadow-lg">
                  <div className="w-full h-full bg-black rounded-[1.5rem] overflow-hidden relative">
                    <video
                      autoPlay
                      loop
                      muted
                      playsInline
                      className="w-full h-full object-cover"
                      poster="/images/demo-mobile.webp"
                    >
                      <source
                        src="/images/demo-video-mobile.mp4"
                        type="video/mp4"
                      />
                    </video>
                  </div>
                </div>
              </div>
              {/* Image (Larger) */}
              <div className="relative w-full max-w-[280px] sm:max-w-[240px] md:max-w-[280px]">
                <div className="w-full aspect-[9/16] border-2 border-black rounded-[2rem] p-1.5 shadow-lg">
                  <div className="w-full h-full bg-black rounded-[1.5rem] overflow-hidden relative">
                    <Image
                      src="/images/demo-mobile.webp"
                      alt="Fresha mobile app demo"
                      fill
                      className="object-cover"
                      priority
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </Container>
    </PageSection>
  );
}
