/**
 * React Query hook for creating a booking
 */

import { useMutation, UseMutationOptions } from "@tanstack/react-query";
import { createBookingClient } from "../api/createBooking";
import {
  Booking,
  CreateBookingRequest,
} from "@/lib/schemas/booking";

export function useCreateBooking(
  options?: UseMutationOptions<Booking, Error, CreateBookingRequest>
) {
  return useMutation({
    mutationFn: createBookingClient,
    ...options,
  });
}




