/**
 * React Query hook for fetching available time slots
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { getAvailableSlotsClient } from "../api/getAvailableSlots";
import { TimeSlot, AvailableSlotsRequest } from "@/lib/schemas/booking";

export function useAvailableSlots(
  request: AvailableSlotsRequest,
  options?: Omit<
    UseQueryOptions<TimeSlot[], Error, TimeSlot[], string[]>,
    "queryKey" | "queryFn" | "enabled"
  >
) {
  return useQuery({
    queryKey: [
      "available-slots",
      request.venueId,
      request.date,
      request.serviceIds.join(","),
      request.professionalId || "any",
    ],
    queryFn: () => getAvailableSlotsClient(request),
    enabled: !!request.venueId && !!request.date && request.serviceIds.length > 0,
    ...options,
  });
}




