import { ButtonHTMLAttributes } from "react";
import { Apple } from "lucide-react";
import { cn } from "@/lib/classNames";
import { Spinner } from "@/components/feedback/Spinner";

interface SocialLoginButtonProps extends ButtonHTMLAttributes<HTMLButtonElement> {
  provider: "google" | "apple";
  children: React.ReactNode;
  loading?: boolean;
}

export function SocialLoginButton({
  provider,
  children,
  className = "",
  loading = false,
  disabled,
  ...props
}: SocialLoginButtonProps) {
  return (
    <button
      className={cn(
        "w-full px-4 py-3 rounded-xl border border-gray-300 bg-white",
        "flex items-center gap-3 transition-colors",
        "hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-gray-900 focus:ring-offset-0",
        "disabled:opacity-50 disabled:cursor-not-allowed",
        className
      )}
      disabled={disabled || loading}
      {...props}
    >
      {loading ? (
        <Spinner size="sm" />
      ) : (
        <>
          {provider === "google" ? (
            <div className="w-6 h-6 flex items-center justify-center flex-shrink-0">
              <span className="text-lg font-bold bg-gradient-to-br from-blue-500 via-green-500 to-yellow-500 bg-clip-text text-transparent">
                G
              </span>
            </div>
          ) : (
            <div className="w-6 h-6 flex items-center justify-center flex-shrink-0">
              <Apple className="w-6 h-6 text-gray-900" />
            </div>
          )}
        </>
      )}
      <span className="button-text flex-1 text-left">{children}</span>
    </button>
  );
}
