import { ReactNode } from "react";
import Image from "next/image";

interface AuthLayoutSplitProps {
  children: ReactNode;
  imageSrc?: string;
  imageAlt?: string;
}

export function AuthLayoutSplit({
  children,
  imageSrc = "https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=800&h=1200&fit=crop",
  imageAlt = "Fresha user",
}: AuthLayoutSplitProps) {
  return (
    <div className="min-h-screen flex">
      {/* Left Side - Form Content */}
      <div className="w-full lg:w-1/2 flex flex-col bg-white">
        <div className="flex-1 flex flex-col justify-center px-6 py-12 lg:px-12">
          {children}
        </div>
      </div>

      {/* Right Side - Image */}
      <div className="hidden lg:block lg:w-1/2 relative overflow-hidden">
        <div className="absolute inset-0">
          <Image
            src={imageSrc}
            alt={imageAlt}
            fill
            className="object-cover"
            priority
          />
        </div>
      </div>
    </div>
  );
}
