/**
 * Login API
 * Handles customer login with email and password
 */

import { API_BASE_URL } from "@/config/env";
import { getDeviceToken } from "@/lib/deviceToken";

export interface LoginRequest {
  email: string;
  password: string;
  dvToken: string;
}

export interface LoginResponse {
  status: string;
  message: string;
  data: {
    accessToken?: string;
    userId?: string;
    image?: string;
    firstName?: string;
    lastName?: string;
    email?: string;
    phoneNum?: string;
    stripeCustomerId?: string | null;
  };
  error: string;
}

/**
 * Login with email and password
 * Returns response with different statuses:
 * - "1": Login successful (verified user)
 * - "2": Not verified (needs OTP verification, returns userId)
 * - "0": Invalid email/user not found
 */
export async function login(
  email: string,
  password: string
): Promise<LoginResponse> {
  const dvToken = getDeviceToken();

  const response = await fetch(`${API_BASE_URL}/customer-auth/login`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Accept: "application/json",
    },
    body: JSON.stringify({
      email,
      password,
      dvToken,
    }),
  });

  const data: LoginResponse = await response.json();
  return data;
}




