/**
 * Forgot Password API
 * Initiates password recovery process with OTP verification
 */

import { API_BASE_URL } from "@/config/env";
import { getDeviceToken } from "@/lib/deviceToken";

export interface ForgotPasswordRequest {
  email: string;
  userId?: string;
}

export interface ForgotPasswordResponse {
  status: string;
  message: string;
  data: {
    otpId: string;
    userId: string;
  };
  error: string;
}

/**
 * Initiate password recovery process
 * Sends OTP to user's email for password reset
 * Returns otpId and userId for verification
 */
export async function forgotPassword(
  email: string,
  userId?: string
): Promise<ForgotPasswordResponse> {
  const response = await fetch(`${API_BASE_URL}/customer-auth/forgot-password`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Accept: "application/json",
    },
    body: JSON.stringify({
      email,
      userId: userId || "",
    }),
  });

  const data: ForgotPasswordResponse = await response.json();
  return data;
}




