/**
 * Environment Configuration
 */

// Determine if we're in production mode
// Checks both NODE_ENV and custom environment variable
const isProduction =
  process.env.NODE_ENV === "production" ||
  process.env.NEXT_PUBLIC_ENVIRONMENT === "production";

// API Base URL Configuration
// Test URL: https://stage.trimworldwide.com/ (for development)
// Live URL: https://backend.trimworldwide.com/ (for production)
// Can be overridden with NEXT_PUBLIC_API_BASE_URL environment variable
export const API_BASE_URL =
  process.env.NEXT_PUBLIC_API_BASE_URL ||
  (isProduction
    ? "https://backend.trimworldwide.com/"
    : "https://stage.trimworldwide.com/");

export const API_ENDPOINTS = {
  emailChecker: "/customer-auth/emailChecker",
  signup: "/customer-auth/signup",
  verifyOtp: "/customer-auth/verify-otp",
  login: "/customer-auth/login",
  resendOtp: "/customer-auth/resend-otp",
  forgotPassword: "/customer-auth/forgot-password",
  verifyOtpForgotPassword: "/customer-auth/verify-otp-forget-password",
  resetPassword: "/customer-auth/reset-password",
} as const;

export const googleApiKey = process.env.NEXT_PUBLIC_GOOGLE_MAPS_KEY || "";

// Stripe Configuration
// Test key (starts with pk_test_) - used in development
const STRIPE_PUBLIC_KEY_TEST =
  process.env.NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_TEST || "";

// Live key (starts with pk_live_) - used in production
const STRIPE_PUBLIC_KEY_LIVE =
  process.env.NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_LIVE || "";

// Export the appropriate Stripe key based on environment
// Production → LIVE key, Development → TEST key
export const STRIPE_PUBLISHABLE_KEY = isProduction
  ? STRIPE_PUBLIC_KEY_LIVE
  : STRIPE_PUBLIC_KEY_TEST;
