"use client";

import { cn } from "@/lib/classNames";
import { ReactNode, useState } from "react";

interface AvatarProps {
  children?: ReactNode;
  className?: string;
}

export function Avatar({ children, className }: AvatarProps) {
  return (
    <div
      className={cn(
        "relative flex h-10 w-10 shrink-0 overflow-hidden rounded-full",
        className
      )}
    >
      {children}
    </div>
  );
}

export function AvatarImage({ src, alt }: { src?: string; alt?: string }) {
  const [error, setError] = useState(false);
  
  if (!src || error) return null;
  
  return (
    <img
      src={src}
      alt={alt}
      className="h-full w-full object-cover"
      onError={() => setError(true)}
    />
  );
}

export function AvatarFallback({
  children,
  className,
}: {
  children: ReactNode;
  className?: string;
}) {
  return (
    <div
      className={cn(
        "absolute inset-0 flex items-center justify-center bg-gray-100 text-gray-600 text-sm font-medium",
        className
      )}
    >
      {children}
    </div>
  );
}
