"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import { routes } from "@/config/routes";
import { User, Calendar, Heart, Settings } from "lucide-react";
import { cn } from "@/lib/classNames";
import { getUserData } from "@/lib/auth";

interface NavItem {
  label: string;
  href: string;
  icon: React.ComponentType<{ className?: string }>;
}

const navItems: NavItem[] = [
  { label: "Profile", href: routes.profile, icon: User },
  { label: "Appointments", href: routes.profileAppointments, icon: Calendar },
  { label: "Favorites", href: routes.profileFavorites, icon: Heart },
  { label: "Settings", href: routes.profileSettings, icon: Settings },
];

export function SideNav() {
  const pathname = usePathname();
  const userData = getUserData();
  const userName =
    userData?.firstName && userData?.lastName
      ? `${userData.firstName} ${userData.lastName}`
      : userData?.email || "User";

  return (
    <aside className="fixed left-0 top-20 w-64 h-[calc(100vh-5rem)] bg-white overflow-y-auto z-40">
      <div className="h-full flex flex-col p-6">
        <div className="mb-6">
          <h2 className="heading-6 text-gray-900 font-bold">{userName}</h2>
        </div>
        <nav className="space-y-1 flex-1">
          {navItems.map((item) => {
            const Icon = item.icon;
            const isActive = pathname === item.href;

            return (
              <Link
                key={item.href}
                href={item.href}
                className={cn(
                  "flex items-center gap-3 px-4 py-3 rounded-lg transition-colors",
                  isActive
                    ? "bg-purple-50 text-purple-700 font-medium"
                    : "text-gray-700 hover:bg-gray-50"
                )}
              >
                <Icon
                  className={cn(
                    "w-5 h-5",
                    isActive ? "text-purple-700" : "text-gray-500"
                  )}
                />
                <span className="body-text-sm">{item.label}</span>
              </Link>
            );
          })}
        </nav>
      </div>
    </aside>
  );
}
