import Link from "next/link";
import { Facebook, Twitter, Youtube, Instagram, Globe } from "lucide-react";
import { routes } from "@/config/routes";
import { Container } from "@/components/layout/Container";

export function Footer() {
  return (
    <footer style={{ backgroundColor: "var(--color-gray-50)" }}>
      <Container>
        <div className="py-12">
          {/* Top Part of Footer */}
          <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-5 gap-6 md:gap-8 mb-8 md:mb-12">
            {/* Brand Column */}
            <div className="col-span-2 sm:col-span-1 md:col-span-1">
              <Link href={routes.home} className="flex items-center gap-2 mb-4">
                <span className="text-2xl font-bold lowercase" style={{ color: "var(--text-primary)" }}>
                  fresha
                </span>
              </Link>
              {/* App Button - White pill, light grey border, black text + icons */}
              <button
                className="px-4 py-2 rounded-full text-sm font-medium flex items-center gap-2 transition-colors"
                style={{
                  backgroundColor: "var(--surface)",
                  border: "1px solid var(--color-gray-300)",
                  color: "var(--text-primary)",
                }}
              >
                Get the app
                <div className="flex gap-1">
                  <div className="w-4 h-4 border border-gray-400 rounded"></div>
                  <div className="w-4 h-4 border border-gray-400 rounded"></div>
                </div>
              </button>
            </div>

            {/* About Fresha Column - Section titles semi-bold, links regular dark grey */}
            <div>
              <h3 className="font-semibold mb-4" style={{ color: "var(--text-primary)" }}>
                About Fresha
              </h3>
              <ul className="space-y-2">
                <li>
                  <Link
                    href="/careers"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Careers
                  </Link>
                </li>
                <li>
                  <Link
                    href="/help"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Help and support
                  </Link>
                </li>
                <li>
                  <Link
                    href="/blog"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Blog
                  </Link>
                </li>
                <li>
                  <Link
                    href="/sitemap"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Sitemap
                  </Link>
                </li>
              </ul>
            </div>

            {/* For Business Column */}
            <div>
              <h3 className="font-semibold mb-4" style={{ color: "var(--text-primary)" }}>
                For business
              </h3>
              <ul className="space-y-2">
                <li>
                  <Link
                    href="/partners"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    For partners
                  </Link>
                </li>
                <li>
                  <Link
                    href="/pricing"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Pricing
                  </Link>
                </li>
                <li>
                  <Link
                    href="/support"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Support
                  </Link>
                </li>
                <li>
                  <Link
                    href="/status"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Status
                  </Link>
                </li>
              </ul>
            </div>

            {/* Legal Column */}
            <div>
              <h3 className="font-semibold mb-4" style={{ color: "var(--text-primary)" }}>
                Legal
              </h3>
              <ul className="space-y-2">
                <li>
                  <Link
                    href="/privacy"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Privacy Policy
                  </Link>
                </li>
                <li>
                  <Link
                    href="/terms"
                    className="text-sm font-normal hover:underline block"
                    style={{ color: "var(--color-gray-600)" }}
                  >
                    Terms of service
                  </Link>
                </li>
              </ul>
            </div>

            {/* Social Media Column */}
            <div>
              <h3 className="font-semibold mb-4" style={{ color: "var(--text-primary)" }}>
                Find us on social
              </h3>
              <div className="flex gap-4">
                <Link
                  href="https://facebook.com"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="hover:opacity-70 transition-opacity"
                  aria-label="Facebook"
                  style={{ color: "var(--color-gray-600)" }}
                >
                  <Facebook className="w-5 h-5" />
                </Link>
                <Link
                  href="https://twitter.com"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="hover:opacity-70 transition-opacity"
                  aria-label="Twitter"
                  style={{ color: "var(--color-gray-600)" }}
                >
                  <Twitter className="w-5 h-5" />
                </Link>
                <Link
                  href="https://linkedin.com"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="hover:opacity-70 transition-opacity"
                  aria-label="LinkedIn"
                  style={{ color: "var(--color-gray-600)" }}
                >
                  <Youtube className="w-5 h-5" />
                </Link>
                <Link
                  href="https://instagram.com"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="hover:opacity-70 transition-opacity"
                  aria-label="Instagram"
                  style={{ color: "var(--color-gray-600)" }}
                >
                  <Instagram className="w-5 h-5" />
                </Link>
              </div>
            </div>
          </div>

          {/* Bottom Copyright Bar - Same grey, thin top border, small grey text */}
          <div
            className="pt-6 flex flex-col md:flex-row items-center justify-between gap-4"
            style={{
              borderTop: "1px solid var(--color-gray-200)",
            }}
          >
            <div className="flex items-center gap-2">
              <Globe className="w-4 h-4" style={{ color: "var(--color-gray-500)" }} />
              <span className="text-sm font-normal" style={{ color: "var(--color-gray-500)" }}>
                English
              </span>
            </div>
            <p className="text-sm font-normal" style={{ color: "var(--color-gray-500)" }}>
              © 2023 Fresha.com Ltd.
            </p>
          </div>
        </div>
      </Container>
    </footer>
  );
}
